/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import java.math.BigDecimal;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.util.DecimalUtility;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@FunctionTemplate(name="to_timestamp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class GVarDecimalToTimeStamp
implements DrillSimpleFunc {
    @Param
    VarDecimalHolder left;
    @Output
    TimeStampHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        long inputMillis = 0L;
        BigDecimal input = DecimalUtility.getBigDecimalFromDrillBuf(this.left.buffer, this.left.start, this.left.end - this.left.start, this.left.scale);
        inputMillis = input.multiply(new BigDecimal(1000)).longValue();
        this.out.value = new DateTime(inputMillis).withZoneRetainFields(DateTimeZone.UTC).getMillis();
    }
}

