/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;

public class GTimestampDiff {

    @FunctionTemplate(name="timestampdiffQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffQuarterTimeToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 3;
        }
    }

    @FunctionTemplate(name="timestampdiffQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffQuarterTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 3;
        }
    }

    @FunctionTemplate(name="timestampdiffQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffQuarterTimeToDate
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 3;
        }
    }

    @FunctionTemplate(name="timestampdiffQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffQuarterTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 3;
        }
    }

    @FunctionTemplate(name="timestampdiffQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffQuarterTimeStampToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 3;
        }
    }

    @FunctionTemplate(name="timestampdiffQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffQuarterTimeStampToDate
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 3;
        }
    }

    @FunctionTemplate(name="timestampdiffQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffQuarterDateToTime
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 3;
        }
    }

    @FunctionTemplate(name="timestampdiffQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffQuarterDateToTimeStamp
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 3;
        }
    }

    @FunctionTemplate(name="timestampdiffQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffQuarterDateToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 3;
        }
    }

    @FunctionTemplate(name="timestampdiffWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffWeekTimeToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 604800000;
        }
    }

    @FunctionTemplate(name="timestampdiffWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffWeekTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) / 604800000L;
        }
    }

    @FunctionTemplate(name="timestampdiffWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffWeekTimeToDate
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) / 604800000L;
        }
    }

    @FunctionTemplate(name="timestampdiffWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffWeekTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) / 604800000L;
        }
    }

    @FunctionTemplate(name="timestampdiffWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffWeekTimeStampToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 604800000L;
        }
    }

    @FunctionTemplate(name="timestampdiffWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffWeekTimeStampToDate
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 604800000L;
        }
    }

    @FunctionTemplate(name="timestampdiffWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffWeekDateToTime
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) / 604800000L;
        }
    }

    @FunctionTemplate(name="timestampdiffWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffWeekDateToTimeStamp
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 604800000L;
        }
    }

    @FunctionTemplate(name="timestampdiffWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffWeekDateToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 604800000L;
        }
    }

    @FunctionTemplate(name="timestampdiffYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffYearTimeToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 12;
        }
    }

    @FunctionTemplate(name="timestampdiffYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffYearTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 12;
        }
    }

    @FunctionTemplate(name="timestampdiffYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffYearTimeToDate
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 12;
        }
    }

    @FunctionTemplate(name="timestampdiffYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffYearTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 12;
        }
    }

    @FunctionTemplate(name="timestampdiffYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffYearTimeStampToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 12;
        }
    }

    @FunctionTemplate(name="timestampdiffYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffYearTimeStampToDate
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 12;
        }
    }

    @FunctionTemplate(name="timestampdiffYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffYearDateToTime
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 12;
        }
    }

    @FunctionTemplate(name="timestampdiffYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffYearDateToTimeStamp
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 12;
        }
    }

    @FunctionTemplate(name="timestampdiffYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffYearDateToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months / 12;
        }
    }

    @FunctionTemplate(name="timestampdiffMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMonthTimeToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months;
        }
    }

    @FunctionTemplate(name="timestampdiffMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMonthTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months;
        }
    }

    @FunctionTemplate(name="timestampdiffMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMonthTimeToDate
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months;
        }
    }

    @FunctionTemplate(name="timestampdiffMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMonthTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months;
        }
    }

    @FunctionTemplate(name="timestampdiffMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMonthTimeStampToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months;
        }
    }

    @FunctionTemplate(name="timestampdiffMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMonthTimeStampToDate
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months;
        }
    }

    @FunctionTemplate(name="timestampdiffMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMonthDateToTime
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months;
        }
    }

    @FunctionTemplate(name="timestampdiffMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMonthDateToTimeStamp
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months;
        }
    }

    @FunctionTemplate(name="timestampdiffMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMonthDateToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            int months = (int)from.until(to, ChronoUnit.MONTHS);
            this.out.value = months;
        }
    }

    @FunctionTemplate(name="timestampdiffDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffDayTimeToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 86400000;
        }
    }

    @FunctionTemplate(name="timestampdiffDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffDayTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) / 86400000L;
        }
    }

    @FunctionTemplate(name="timestampdiffDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffDayTimeToDate
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) / 86400000L;
        }
    }

    @FunctionTemplate(name="timestampdiffDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffDayTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) / 86400000L;
        }
    }

    @FunctionTemplate(name="timestampdiffDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffDayTimeStampToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 86400000L;
        }
    }

    @FunctionTemplate(name="timestampdiffDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffDayTimeStampToDate
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 86400000L;
        }
    }

    @FunctionTemplate(name="timestampdiffDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffDayDateToTime
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) / 86400000L;
        }
    }

    @FunctionTemplate(name="timestampdiffDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffDayDateToTimeStamp
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 86400000L;
        }
    }

    @FunctionTemplate(name="timestampdiffDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffDayDateToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 86400000L;
        }
    }

    @FunctionTemplate(name="timestampdiffHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffHourTimeToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 3600000;
        }
    }

    @FunctionTemplate(name="timestampdiffHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffHourTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) / 3600000L;
        }
    }

    @FunctionTemplate(name="timestampdiffHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffHourTimeToDate
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) / 3600000L;
        }
    }

    @FunctionTemplate(name="timestampdiffHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffHourTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) / 3600000L;
        }
    }

    @FunctionTemplate(name="timestampdiffHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffHourTimeStampToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 3600000L;
        }
    }

    @FunctionTemplate(name="timestampdiffHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffHourTimeStampToDate
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 3600000L;
        }
    }

    @FunctionTemplate(name="timestampdiffHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffHourDateToTime
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) / 3600000L;
        }
    }

    @FunctionTemplate(name="timestampdiffHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffHourDateToTimeStamp
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 3600000L;
        }
    }

    @FunctionTemplate(name="timestampdiffHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffHourDateToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 3600000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMinuteTimeToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 60000;
        }
    }

    @FunctionTemplate(name="timestampdiffMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMinuteTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) / 60000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMinuteTimeToDate
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) / 60000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMinuteTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) / 60000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMinuteTimeStampToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 60000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMinuteTimeStampToDate
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 60000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMinuteDateToTime
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) / 60000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMinuteDateToTimeStamp
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 60000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMinuteDateToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 60000L;
        }
    }

    @FunctionTemplate(name="timestampdiffSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffSecondTimeToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 1000;
        }
    }

    @FunctionTemplate(name="timestampdiffSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffSecondTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) / 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffSecondTimeToDate
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) / 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffSecondTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) / 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffSecondTimeStampToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffSecondTimeStampToDate
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffSecondDateToTime
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) / 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffSecondDateToTimeStamp
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffSecondDateToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) / 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMillisecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMillisecondTimeToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.value - this.left.value;
        }
    }

    @FunctionTemplate(name="timestampdiffMillisecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMillisecondTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.value - (long)this.left.value;
        }
    }

    @FunctionTemplate(name="timestampdiffMillisecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMillisecondTimeToDate
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.value - (long)this.left.value;
        }
    }

    @FunctionTemplate(name="timestampdiffMillisecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMillisecondTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (long)this.right.value - this.left.value;
        }
    }

    @FunctionTemplate(name="timestampdiffMillisecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMillisecondTimeStampToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.value - this.left.value;
        }
    }

    @FunctionTemplate(name="timestampdiffMillisecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMillisecondTimeStampToDate
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.value - this.left.value;
        }
    }

    @FunctionTemplate(name="timestampdiffMillisecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMillisecondDateToTime
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (long)this.right.value - this.left.value;
        }
    }

    @FunctionTemplate(name="timestampdiffMillisecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMillisecondDateToTimeStamp
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.value - this.left.value;
        }
    }

    @FunctionTemplate(name="timestampdiffMillisecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMillisecondDateToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.value - this.left.value;
        }
    }

    @FunctionTemplate(name="timestampdiffMicrosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMicrosecondTimeToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) * 1000;
        }
    }

    @FunctionTemplate(name="timestampdiffMicrosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMicrosecondTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) * 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMicrosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMicrosecondTimeToDate
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) * 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMicrosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMicrosecondTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) * 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMicrosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMicrosecondTimeStampToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) * 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMicrosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMicrosecondTimeStampToDate
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) * 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMicrosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMicrosecondDateToTime
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) * 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMicrosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMicrosecondDateToTimeStamp
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) * 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffMicrosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffMicrosecondDateToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) * 1000L;
        }
    }

    @FunctionTemplate(name="timestampdiffNanosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffNanosecondTimeToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) * 1000000;
        }
    }

    @FunctionTemplate(name="timestampdiffNanosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffNanosecondTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) * 1000000L;
        }
    }

    @FunctionTemplate(name="timestampdiffNanosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffNanosecondTimeToDate
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - (long)this.left.value) * 1000000L;
        }
    }

    @FunctionTemplate(name="timestampdiffNanosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffNanosecondTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) * 1000000L;
        }
    }

    @FunctionTemplate(name="timestampdiffNanosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffNanosecondTimeStampToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) * 1000000L;
        }
    }

    @FunctionTemplate(name="timestampdiffNanosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffNanosecondTimeStampToDate
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) * 1000000L;
        }
    }

    @FunctionTemplate(name="timestampdiffNanosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffNanosecondDateToTime
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ((long)this.right.value - this.left.value) * 1000000L;
        }
    }

    @FunctionTemplate(name="timestampdiffNanosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffNanosecondDateToTimeStamp
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) * 1000000L;
        }
    }

    @FunctionTemplate(name="timestampdiffNanosecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimestampDiffNanosecondDateToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (this.right.value - this.left.value) * 1000000L;
        }
    }
}

