/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import com.google.common.base.Charsets;
import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@FunctionTemplate(name="to_char", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class GTimeStampToChar
implements DrillSimpleFunc {
    @Param
    TimeStampHolder left;
    @Param
    VarCharHolder right;
    @Inject
    DrillBuf buffer;
    @Workspace
    MutableDateTime temp;
    @Workspace
    DateTimeFormatter format;
    @Output
    VarCharHolder out;

    @Override
    public void setup() {
        this.temp = new MutableDateTime(0L, DateTimeZone.UTC);
        this.buffer = this.buffer.reallocIfNeeded(100);
        byte[] buf = new byte[this.right.end - this.right.start];
        this.right.buffer.getBytes(this.right.start, buf, 0, this.right.end - this.right.start);
        String input = new String(buf, Charsets.UTF_8);
        this.format = DateTimeFormat.forPattern((String)input);
    }

    @Override
    public void eval() {
        this.temp.setMillis(this.left.value);
        String str = this.format.print((ReadableInstant)this.temp);
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = Math.min(100, str.length());
        this.out.buffer.setBytes(0, str.substring(0, this.out.end).getBytes(StandardCharsets.UTF_8));
    }
}

