/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;

public class GTimeStampArithmetic {

    @FunctionTemplate(names={"date_diff", "subtract", "date_sub"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampDifference
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        IntervalDayHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            long difference = this.left.value - this.right.value;
            this.out.milliseconds = (int)(difference % 86400000L);
            this.out.days = (int)(difference / 86400000L);
        }
    }
}

