/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMathFunctions {
    static final Logger logger = LoggerFactory.getLogger(GMathFunctions.class);

    private GMathFunctions() {
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RounddUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.HALF_UP).doubleValue();
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RounddUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.HALF_UP).doubleValue();
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RounddUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.HALF_UP).doubleValue();
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RounddUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.HALF_UP).doubleValue();
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RounddTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.HALF_UP).doubleValue();
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RounddSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.HALF_UP).doubleValue();
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RounddFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.HALF_UP).doubleValue();
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RounddFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.HALF_UP).doubleValue();
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RounddBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.HALF_UP).doubleValue();
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RounddInt
    implements DrillSimpleFunc {
        @Param
        IntHolder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.HALF_UP).doubleValue();
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncateUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.DOWN).doubleValue();
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncateUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.DOWN).doubleValue();
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncateUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.DOWN).doubleValue();
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncateUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.DOWN).doubleValue();
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncateTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.DOWN).doubleValue();
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncateSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.DOWN).doubleValue();
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncateFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (Double.isInfinite(this.input1.value) || Double.isNaN(this.input1.value)) {
                this.out.value = Double.NaN;
            } else {
                BigDecimal temp = new BigDecimal(this.input1.value);
                this.out.value = temp.setScale(this.input2.value, RoundingMode.DOWN).doubleValue();
            }
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncateFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (Double.isInfinite(this.input1.value) || Double.isNaN(this.input1.value)) {
                this.out.value = Double.NaN;
            } else {
                BigDecimal temp = new BigDecimal(this.input1.value);
                this.out.value = temp.setScale(this.input2.value, RoundingMode.DOWN).doubleValue();
            }
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncateBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.DOWN).doubleValue();
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncateInt
    implements DrillSimpleFunc {
        @Param
        IntHolder input1;
        @Param
        IntHolder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal temp = new BigDecimal(this.input1.value);
            this.out.value = temp.setScale(this.input2.value, RoundingMode.DOWN).doubleValue();
        }
    }

    @FunctionTemplate(names={"xor", "^"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class XorUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder input1;
        @Param
        UInt8Holder input2;
        @Output
        UInt8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value ^ this.input2.value;
        }
    }

    @FunctionTemplate(names={"xor", "^"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class XorUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder input1;
        @Param
        UInt4Holder input2;
        @Output
        UInt4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value ^ this.input2.value;
        }
    }

    @FunctionTemplate(names={"xor", "^"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class XorUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder input1;
        @Param
        UInt2Holder input2;
        @Output
        UInt2Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (char)(this.input1.value ^ this.input2.value);
        }
    }

    @FunctionTemplate(names={"xor", "^"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class XorUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder input1;
        @Param
        UInt1Holder input2;
        @Output
        UInt1Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)(this.input1.value ^ this.input2.value);
        }
    }

    @FunctionTemplate(names={"xor", "^"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class XorTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder input1;
        @Param
        TinyIntHolder input2;
        @Output
        TinyIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)(this.input1.value ^ this.input2.value);
        }
    }

    @FunctionTemplate(names={"xor", "^"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class XorSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder input1;
        @Param
        SmallIntHolder input2;
        @Output
        SmallIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (short)(this.input1.value ^ this.input2.value);
        }
    }

    @FunctionTemplate(names={"xor", "^"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class XorBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder input1;
        @Param
        BigIntHolder input2;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value ^ this.input2.value;
        }
    }

    @FunctionTemplate(names={"xor", "^"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class XorInt
    implements DrillSimpleFunc {
        @Param
        IntHolder input1;
        @Param
        IntHolder input2;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value ^ this.input2.value;
        }
    }

    @FunctionTemplate(name="rshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RightShiftUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder input1;
        @Param
        UInt8Holder input2;
        @Output
        UInt8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value >> (int)this.input2.value;
        }
    }

    @FunctionTemplate(name="rshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RightShiftUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder input1;
        @Param
        UInt4Holder input2;
        @Output
        UInt4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value >> this.input2.value;
        }
    }

    @FunctionTemplate(name="rshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RightShiftUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder input1;
        @Param
        UInt2Holder input2;
        @Output
        UInt2Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (char)(this.input1.value >> this.input2.value);
        }
    }

    @FunctionTemplate(name="rshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RightShiftUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder input1;
        @Param
        UInt1Holder input2;
        @Output
        UInt1Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)(this.input1.value >> this.input2.value);
        }
    }

    @FunctionTemplate(name="rshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RightShiftTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder input1;
        @Param
        TinyIntHolder input2;
        @Output
        TinyIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)(this.input1.value >> this.input2.value);
        }
    }

    @FunctionTemplate(name="rshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RightShiftSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder input1;
        @Param
        SmallIntHolder input2;
        @Output
        SmallIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (short)(this.input1.value >> this.input2.value);
        }
    }

    @FunctionTemplate(name="rshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RightShiftBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder input1;
        @Param
        BigIntHolder input2;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value >> (int)this.input2.value;
        }
    }

    @FunctionTemplate(name="rshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RightShiftInt
    implements DrillSimpleFunc {
        @Param
        IntHolder input1;
        @Param
        IntHolder input2;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value >> this.input2.value;
        }
    }

    @FunctionTemplate(name="lshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LeftShiftUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder input1;
        @Param
        UInt8Holder input2;
        @Output
        UInt8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value << (int)this.input2.value;
        }
    }

    @FunctionTemplate(name="lshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LeftShiftUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder input1;
        @Param
        UInt4Holder input2;
        @Output
        UInt4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value << this.input2.value;
        }
    }

    @FunctionTemplate(name="lshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LeftShiftUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder input1;
        @Param
        UInt2Holder input2;
        @Output
        UInt2Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (char)(this.input1.value << this.input2.value);
        }
    }

    @FunctionTemplate(name="lshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LeftShiftUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder input1;
        @Param
        UInt1Holder input2;
        @Output
        UInt1Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)(this.input1.value << this.input2.value);
        }
    }

    @FunctionTemplate(name="lshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LeftShiftTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder input1;
        @Param
        TinyIntHolder input2;
        @Output
        TinyIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)(this.input1.value << this.input2.value);
        }
    }

    @FunctionTemplate(name="lshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LeftShiftSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder input1;
        @Param
        SmallIntHolder input2;
        @Output
        SmallIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (short)(this.input1.value << this.input2.value);
        }
    }

    @FunctionTemplate(name="lshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LeftShiftBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder input1;
        @Param
        BigIntHolder input2;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value << (int)this.input2.value;
        }
    }

    @FunctionTemplate(name="lshift", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LeftShiftInt
    implements DrillSimpleFunc {
        @Param
        IntHolder input1;
        @Param
        IntHolder input2;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value << this.input2.value;
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ModUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder input1;
        @Param
        UInt8Holder input2;
        @Output
        UInt8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input2.value == 0L ? this.input1.value : this.input1.value % this.input2.value;
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ModUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder input1;
        @Param
        UInt4Holder input2;
        @Output
        UInt4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input2.value == 0 ? this.input1.value : this.input1.value % this.input2.value;
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ModUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder input1;
        @Param
        UInt2Holder input2;
        @Output
        UInt2Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (char)(this.input2.value == '\u0000' ? this.input1.value : this.input1.value % this.input2.value);
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ModUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder input1;
        @Param
        UInt1Holder input2;
        @Output
        UInt1Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)(this.input2.value == 0 ? this.input1.value : this.input1.value % this.input2.value);
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ModTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder input1;
        @Param
        TinyIntHolder input2;
        @Output
        TinyIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)(this.input2.value == 0 ? this.input1.value : this.input1.value % this.input2.value);
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ModSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder input1;
        @Param
        SmallIntHolder input2;
        @Output
        SmallIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (short)(this.input2.value == 0 ? this.input1.value : this.input1.value % this.input2.value);
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ModFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder input1;
        @Param
        Float8Holder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input2.value == 0.0 ? this.input1.value : this.input1.value % this.input2.value;
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ModFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder input1;
        @Param
        Float4Holder input2;
        @Output
        Float4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input2.value == 0.0f ? this.input1.value : this.input1.value % this.input2.value;
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ModBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder input1;
        @Param
        BigIntHolder input2;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input2.value == 0L ? this.input1.value : this.input1.value % this.input2.value;
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ModInt
    implements DrillSimpleFunc {
        @Param
        IntHolder input1;
        @Param
        IntHolder input2;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input2.value == 0 ? this.input1.value : this.input1.value % this.input2.value;
        }
    }

    @FunctionTemplate(name="div", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DivUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder input1;
        @Param
        UInt8Holder input2;
        @Output
        UInt8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value / this.input2.value;
        }
    }

    @FunctionTemplate(name="div", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DivUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder input1;
        @Param
        UInt4Holder input2;
        @Output
        UInt4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value / this.input2.value;
        }
    }

    @FunctionTemplate(name="div", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DivUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder input1;
        @Param
        UInt2Holder input2;
        @Output
        UInt2Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (char)(this.input1.value / this.input2.value);
        }
    }

    @FunctionTemplate(name="div", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DivUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder input1;
        @Param
        UInt1Holder input2;
        @Output
        UInt1Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)(this.input1.value / this.input2.value);
        }
    }

    @FunctionTemplate(name="div", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DivTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder input1;
        @Param
        TinyIntHolder input2;
        @Output
        TinyIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)(this.input1.value / this.input2.value);
        }
    }

    @FunctionTemplate(name="div", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DivSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder input1;
        @Param
        SmallIntHolder input2;
        @Output
        SmallIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (short)(this.input1.value / this.input2.value);
        }
    }

    @FunctionTemplate(name="div", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DivFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder input1;
        @Param
        Float8Holder input2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal bdOut = BigDecimal.valueOf(this.input1.value / this.input2.value).setScale(0, 1);
            this.out.value = bdOut.doubleValue();
        }
    }

    @FunctionTemplate(name="div", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DivFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder input1;
        @Param
        Float4Holder input2;
        @Output
        Float4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            BigDecimal bdOut = BigDecimal.valueOf(this.input1.value / this.input2.value).setScale(0, 1);
            this.out.value = bdOut.floatValue();
        }
    }

    @FunctionTemplate(name="div", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DivBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder input1;
        @Param
        BigIntHolder input2;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value / this.input2.value;
        }
    }

    @FunctionTemplate(name="div", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DivInt
    implements DrillSimpleFunc {
        @Param
        IntHolder input1;
        @Param
        IntHolder input2;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input1.value / this.input2.value;
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SignUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.signum(this.in.value);
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SignUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.signum(this.in.value);
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SignUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.signum(this.in.value);
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SignUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.signum(this.in.value);
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SignTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.signum(this.in.value);
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SignSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.signum(this.in.value);
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SignFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.signum(this.in.value);
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SignFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.signum(this.in.value);
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SignBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.signum(this.in.value);
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SignInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.signum(this.in.value);
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        UInt8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        UInt4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        UInt2Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        UInt1Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        TinyIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        SmallIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (Double.isInfinite(this.in.value) || Double.isNaN(this.in.value)) {
                this.out.value = Double.NaN;
            } else {
                BigDecimal bd = BigDecimal.valueOf(this.in.value).setScale(0, 1);
                this.out.value = bd.doubleValue();
            }
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            if (Double.isInfinite(this.in.value) || Double.isNaN(this.in.value)) {
                this.out.value = Float.NaN;
            } else {
                BigDecimal bd = BigDecimal.valueOf(this.in.value).setScale(0, 1);
                this.out.value = bd.floatValue();
            }
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="trunc", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TruncInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="sqrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SqrtUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sqrt(this.in.value);
        }
    }

    @FunctionTemplate(name="sqrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SqrtUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sqrt(this.in.value);
        }
    }

    @FunctionTemplate(name="sqrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SqrtUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sqrt(this.in.value);
        }
    }

    @FunctionTemplate(name="sqrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SqrtUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sqrt(this.in.value);
        }
    }

    @FunctionTemplate(name="sqrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SqrtTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sqrt(this.in.value);
        }
    }

    @FunctionTemplate(name="sqrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SqrtSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sqrt(this.in.value);
        }
    }

    @FunctionTemplate(name="sqrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SqrtFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sqrt(this.in.value);
        }
    }

    @FunctionTemplate(name="sqrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SqrtFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sqrt(this.in.value);
        }
    }

    @FunctionTemplate(name="sqrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SqrtBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sqrt(this.in.value);
        }
    }

    @FunctionTemplate(name="sqrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SqrtInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.sqrt(this.in.value);
        }
    }

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NegativeUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        UInt8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = -this.in.value;
        }
    }

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NegativeUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        UInt4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = -this.in.value;
        }
    }

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NegativeUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        UInt2Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = -this.in.value;
        }
    }

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NegativeUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        UInt1Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = -this.in.value;
        }
    }

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NegativeTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        TinyIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = -this.in.value;
        }
    }

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NegativeSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        SmallIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = -this.in.value;
        }
    }

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NegativeFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = -this.in.value;
        }
    }

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NegativeFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = -this.in.value;
        }
    }

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NegativeBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = -this.in.value;
        }
    }

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NegativeInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = -this.in.value;
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class FloorUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        UInt8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (long)Math.floor(this.in.value);
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class FloorUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        UInt4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.floor(this.in.value);
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class FloorUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        UInt2Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (char)Math.floor(this.in.value);
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class FloorUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        UInt1Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)Math.floor(this.in.value);
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class FloorTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        TinyIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)Math.floor(this.in.value);
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class FloorSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        SmallIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (short)Math.floor(this.in.value);
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class FloorFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.floor(this.in.value);
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class FloorFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (float)Math.floor(this.in.value);
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class FloorBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (long)Math.floor(this.in.value);
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class FloorInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.floor(this.in.value);
        }
    }

    @FunctionTemplate(name="ceil", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CeilUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        UInt8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (long)Math.ceil(this.in.value);
        }
    }

    @FunctionTemplate(name="ceil", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CeilUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        UInt4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.ceil(this.in.value);
        }
    }

    @FunctionTemplate(name="ceil", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CeilUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        UInt2Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (char)Math.ceil(this.in.value);
        }
    }

    @FunctionTemplate(name="ceil", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CeilUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        UInt1Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)Math.ceil(this.in.value);
        }
    }

    @FunctionTemplate(name="ceil", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CeilTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        TinyIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)Math.ceil(this.in.value);
        }
    }

    @FunctionTemplate(name="ceil", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CeilSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        SmallIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (short)Math.ceil(this.in.value);
        }
    }

    @FunctionTemplate(name="ceil", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CeilFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.ceil(this.in.value);
        }
    }

    @FunctionTemplate(name="ceil", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CeilFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (float)Math.ceil(this.in.value);
        }
    }

    @FunctionTemplate(name="ceil", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CeilBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (long)Math.ceil(this.in.value);
        }
    }

    @FunctionTemplate(name="ceil", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CeilInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)Math.ceil(this.in.value);
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AbsUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        UInt8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.abs(this.in.value);
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AbsUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        UInt4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.abs(this.in.value);
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AbsUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        UInt2Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (char)Math.abs(this.in.value);
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AbsUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        UInt1Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)Math.abs(this.in.value);
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AbsTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        TinyIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)Math.abs(this.in.value);
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AbsSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        SmallIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (short)Math.abs(this.in.value);
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AbsFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.abs(this.in.value);
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AbsFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.abs(this.in.value);
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AbsBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.abs(this.in.value);
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AbsInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Math.abs(this.in.value);
        }
    }
}

