/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;

public class GExtract {

    @FunctionTemplate(name="extractEpoch", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EpochFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class YearFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value / 12;
        }
    }

    @FunctionTemplate(name="extractDayOfYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayOfYearFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractDoy", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DoyFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class QuarterFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MonthFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value % 12;
        }
    }

    @FunctionTemplate(name="extractDayOfWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayOfWeekFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractDow", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DowFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class WeekFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HourFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MinuteFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SecondFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0.0;
        }
    }

    @FunctionTemplate(name="extractEpoch", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EpochFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(name="extractYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class YearFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractDayOfYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayOfYearFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(name="extractDoy", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DoyFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(name="extractQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class QuarterFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MonthFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractDayOfWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayOfWeekFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(name="extractDow", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DowFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(name="extractWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class WeekFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.days;
        }
    }

    @FunctionTemplate(name="extractHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HourFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.milliseconds / 3600000;
        }
    }

    @FunctionTemplate(name="extractMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MinuteFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int millis = this.in.milliseconds % 3600000;
            this.out.value = millis / 60000;
        }
    }

    @FunctionTemplate(name="extractSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SecondFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            long millis = this.in.milliseconds % 60000;
            this.out.value = (double)millis / 1000.0;
        }
    }

    @FunctionTemplate(name="extractEpoch", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EpochFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(name="extractYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class YearFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.months / 12;
        }
    }

    @FunctionTemplate(name="extractDayOfYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayOfYearFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(name="extractDoy", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DoyFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(name="extractQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class QuarterFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.months / 4;
        }
    }

    @FunctionTemplate(name="extractMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MonthFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.months % 12;
        }
    }

    @FunctionTemplate(name="extractDayOfWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayOfWeekFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(name="extractDow", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DowFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
        }
    }

    @FunctionTemplate(name="extractWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class WeekFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.days / 7;
        }
    }

    @FunctionTemplate(name="extractDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.days;
        }
    }

    @FunctionTemplate(name="extractHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HourFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.milliseconds / 3600000;
        }
    }

    @FunctionTemplate(name="extractMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MinuteFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int millis = this.in.milliseconds % 3600000;
            this.out.value = millis / 60000;
        }
    }

    @FunctionTemplate(name="extractSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SecondFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            long millis = this.in.milliseconds % 60000;
            this.out.value = (double)millis / 1000.0;
        }
    }

    @FunctionTemplate(name="extractEpoch", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EpochFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(name="extractYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class YearFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getYear();
        }
    }

    @FunctionTemplate(name="extractDayOfYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayOfYearFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
        }
    }

    @FunctionTemplate(name="extractDoy", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DoyFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getDayOfYear();
        }
    }

    @FunctionTemplate(name="extractQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class QuarterFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getMonthOfYear() / 4 + 1;
        }
    }

    @FunctionTemplate(name="extractMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MonthFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getMonthOfYear();
        }
    }

    @FunctionTemplate(name="extractDayOfWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayOfWeekFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
        }
    }

    @FunctionTemplate(name="extractDow", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DowFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getDayOfWeek();
        }
    }

    @FunctionTemplate(name="extractWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class WeekFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getWeekOfWeekyear();
        }
    }

    @FunctionTemplate(name="extractDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getDayOfMonth();
        }
    }

    @FunctionTemplate(name="extractHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HourFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getHourOfDay();
        }
    }

    @FunctionTemplate(name="extractMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MinuteFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getMinuteOfHour();
        }
    }

    @FunctionTemplate(name="extractSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SecondFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        Float8Holder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getSecondOfMinute();
            this.out.value += (double)this.dateTime.getMillisOfSecond() / 1000.0;
        }
    }

    @FunctionTemplate(name="extractHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HourFromTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis((long)this.in.value);
            this.out.value = this.dateTime.getHourOfDay();
        }
    }

    @FunctionTemplate(name="extractMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MinuteFromTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis((long)this.in.value);
            this.out.value = this.dateTime.getMinuteOfHour();
        }
    }

    @FunctionTemplate(name="extractSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SecondFromTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder in;
        @Output
        Float8Holder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis((long)this.in.value);
            this.out.value = this.dateTime.getSecondOfMinute();
            this.out.value += (double)this.dateTime.getMillisOfSecond() / 1000.0;
        }
    }

    @FunctionTemplate(name="extractEpoch", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EpochFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(name="extractYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class YearFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getYear();
        }
    }

    @FunctionTemplate(name="extractDayOfYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayOfYearFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
        }
    }

    @FunctionTemplate(name="extractDoy", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DoyFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getDayOfYear();
        }
    }

    @FunctionTemplate(name="extractQuarter", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class QuarterFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getMonthOfYear() / 4 + 1;
        }
    }

    @FunctionTemplate(name="extractMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MonthFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getMonthOfYear();
        }
    }

    @FunctionTemplate(name="extractDayOfWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayOfWeekFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
        }
    }

    @FunctionTemplate(name="extractDow", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DowFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getDayOfWeek();
        }
    }

    @FunctionTemplate(name="extractWeek", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class WeekFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getWeekOfWeekyear();
        }
    }

    @FunctionTemplate(name="extractDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getDayOfMonth();
        }
    }

    @FunctionTemplate(name="extractHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HourFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getHourOfDay();
        }
    }

    @FunctionTemplate(name="extractMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MinuteFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getMinuteOfHour();
        }
    }

    @FunctionTemplate(name="extractSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SecondFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        Float8Holder out;
        @Workspace
        MutableDateTime dateTime;

        @Override
        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getSecondOfMinute();
            this.out.value += (double)this.dateTime.getMillisOfSecond() / 1000.0;
        }
    }
}

