/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

public class GCompareVarBinaryVsVarChar {

    @FunctionTemplate(names={"not_equal", "<>", "!="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NotEqualsVarBinaryVsVarChar
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder left;
        @Param
        VarCharHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
            this.out.value = cmp == 0 ? 0 : 1;
        }
    }

    @FunctionTemplate(names={"equal", "==", "="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EqualsVarBinaryVsVarChar
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder left;
        @Param
        VarCharHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ByteFunctionHelpers.equal(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }

    @FunctionTemplate(names={"greater_than_or_equal_to", ">="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanEqVarBinaryVsVarChar
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder left;
        @Param
        VarCharHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
            this.out.value = cmp > -1 ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than", ">"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanVarBinaryVsVarChar
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder left;
        @Param
        VarCharHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
            this.out.value = cmp == 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than_or_equal_to", "<="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanEqVarBinaryVsVarChar
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder left;
        @Param
        VarCharHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
            this.out.value = cmp < 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than", "<"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanVarBinaryVsVarChar
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder left;
        @Param
        VarCharHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            int cmp = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
            this.out.value = cmp == -1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableVarBinaryVsNullableVarCharNullLow
    implements DrillSimpleFunc {
        @Param
        NullableVarBinaryHolder left;
        @Param
        NullableVarCharHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableVarBinaryVsNullableVarCharNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableVarBinaryHolder left;
        @Param
        NullableVarCharHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableVarBinaryVsVarCharNullLow
    implements DrillSimpleFunc {
        @Param
        NullableVarBinaryHolder left;
        @Param
        VarCharHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableVarBinaryVsVarCharNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableVarBinaryHolder left;
        @Param
        VarCharHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareVarBinaryVsNullableVarCharNullLow
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder left;
        @Param
        NullableVarCharHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareVarBinaryVsNullableVarCharNullHigh
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder left;
        @Param
        NullableVarCharHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareVarBinaryVsVarCharNullLow
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder left;
        @Param
        VarCharHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareVarBinaryVsVarCharNullHigh
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder left;
        @Param
        VarCharHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = ByteFunctionHelpers.compare(this.left.buffer, this.left.start, this.left.end, this.right.buffer, this.right.start, this.right.end);
        }
    }
}

