/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;

public class GCompareTimeStampVsTimeStamp {

    @FunctionTemplate(names={"not_equal", "<>", "!="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NotEqualsTimeStampVsTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (this.left.value != this.right.value ? 1 : 0);
        }
    }

    @FunctionTemplate(names={"equal", "==", "="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EqualsTimeStampVsTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 1 : (this.left.value == this.right.value ? 1 : 0);
        }
    }

    @FunctionTemplate(names={"greater_than_or_equal_to", ">="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanEqTimeStampVsTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) ? 1 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (this.left.value >= this.right.value ? 1 : 0));
        }
    }

    @FunctionTemplate(names={"greater_than", ">"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanTimeStampVsTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.right.value) || Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value > this.right.value ? 1 : 0));
        }
    }

    @FunctionTemplate(names={"less_than_or_equal_to", "<="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanEqTimeStampVsTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.right.value) ? 1 : (!Double.isNaN(this.right.value) && Double.isNaN(this.left.value) ? 0 : (this.left.value <= this.right.value ? 1 : 0));
        }
    }

    @FunctionTemplate(names={"less_than", "<"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanTimeStampVsTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) || Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (Double.isNaN(this.right.value) && !Double.isNaN(this.left.value) ? 1 : (this.left.value < this.right.value ? 1 : 0));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableTimeStampVsNullableTimeStampNullLow
    implements DrillSimpleFunc {
        @Param
        NullableTimeStampHolder left;
        @Param
        NullableTimeStampHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1))))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableTimeStampVsNullableTimeStampNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableTimeStampHolder left;
        @Param
        NullableTimeStampHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1))))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableTimeStampVsTimeStampNullLow
    implements DrillSimpleFunc {
        @Param
        NullableTimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableTimeStampVsTimeStampNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableTimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareTimeStampVsNullableTimeStampNullLow
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        NullableTimeStampHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareTimeStampVsNullableTimeStampNullHigh
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        NullableTimeStampHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : (Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareTimeStampVsTimeStampNullLow
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1))));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareTimeStampVsTimeStampNullHigh
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? 0 : (!Double.isNaN(this.left.value) && Double.isNaN(this.right.value) ? -1 : (Double.isNaN(this.left.value) && !Double.isNaN(this.right.value) ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1))));
        }
    }
}

