/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.ops.ContextInformation;

public class GAge {

    @FunctionTemplate(name="age", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AgeTimeToMidnight
    implements DrillSimpleFunc {
        @Param
        TimeHolder right;
        @Workspace
        LocalDateTime to;
        @Output
        IntervalHolder out;
        @Inject
        ContextInformation contextInfo;

        @Override
        public void setup() {
            ZoneId zoneId = this.contextInfo.getRootFragmentTimeZone();
            ZonedDateTime zdtStart = this.contextInfo.getQueryStartInstant().atZone(zoneId);
            this.to = zdtStart.truncatedTo(ChronoUnit.DAYS).toLocalDateTime();
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            long months = from.until(this.to, ChronoUnit.MONTHS);
            from = from.plusMonths(months);
            long days = from.until(this.to, ChronoUnit.DAYS);
            from = from.plusDays(days);
            long millis = from.until(this.to, ChronoUnit.MILLIS);
            this.out.months = (int)months;
            this.out.days = (int)days;
            this.out.milliseconds = (int)millis;
        }
    }

    @FunctionTemplate(name="age", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AgeTimeToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            long months = from.until(to, ChronoUnit.MONTHS);
            from = from.plusMonths(months);
            long days = from.until(to, ChronoUnit.DAYS);
            from = from.plusDays(days);
            long millis = from.until(to, ChronoUnit.MILLIS);
            this.out.months = (int)months;
            this.out.days = (int)days;
            this.out.milliseconds = (int)millis;
        }
    }

    @FunctionTemplate(name="age", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AgeTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            long months = from.until(to, ChronoUnit.MONTHS);
            from = from.plusMonths(months);
            long days = from.until(to, ChronoUnit.DAYS);
            from = from.plusDays(days);
            long millis = from.until(to, ChronoUnit.MILLIS);
            this.out.months = (int)months;
            this.out.days = (int)days;
            this.out.milliseconds = (int)millis;
        }
    }

    @FunctionTemplate(name="age", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AgeTimeToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            long months = from.until(to, ChronoUnit.MONTHS);
            from = from.plusMonths(months);
            long days = from.until(to, ChronoUnit.DAYS);
            from = from.plusDays(days);
            long millis = from.until(to, ChronoUnit.MILLIS);
            this.out.months = (int)months;
            this.out.days = (int)days;
            this.out.milliseconds = (int)millis;
        }
    }

    @FunctionTemplate(name="age", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AgeTimeStampToMidnight
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder right;
        @Workspace
        LocalDateTime to;
        @Output
        IntervalHolder out;
        @Inject
        ContextInformation contextInfo;

        @Override
        public void setup() {
            ZoneId zoneId = this.contextInfo.getRootFragmentTimeZone();
            ZonedDateTime zdtStart = this.contextInfo.getQueryStartInstant().atZone(zoneId);
            this.to = zdtStart.truncatedTo(ChronoUnit.DAYS).toLocalDateTime();
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            long months = from.until(this.to, ChronoUnit.MONTHS);
            from = from.plusMonths(months);
            long days = from.until(this.to, ChronoUnit.DAYS);
            from = from.plusDays(days);
            long millis = from.until(this.to, ChronoUnit.MILLIS);
            this.out.months = (int)months;
            this.out.days = (int)days;
            this.out.milliseconds = (int)millis;
        }
    }

    @FunctionTemplate(name="age", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AgeTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        TimeStampHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            long months = from.until(to, ChronoUnit.MONTHS);
            from = from.plusMonths(months);
            long days = from.until(to, ChronoUnit.DAYS);
            from = from.plusDays(days);
            long millis = from.until(to, ChronoUnit.MILLIS);
            this.out.months = (int)months;
            this.out.days = (int)days;
            this.out.milliseconds = (int)millis;
        }
    }

    @FunctionTemplate(name="age", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AgeTimeStampToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        TimeStampHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            long months = from.until(to, ChronoUnit.MONTHS);
            from = from.plusMonths(months);
            long days = from.until(to, ChronoUnit.DAYS);
            from = from.plusDays(days);
            long millis = from.until(to, ChronoUnit.MILLIS);
            this.out.months = (int)months;
            this.out.days = (int)days;
            this.out.milliseconds = (int)millis;
        }
    }

    @FunctionTemplate(name="age", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AgeTimeStampToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeStampHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            long months = from.until(to, ChronoUnit.MONTHS);
            from = from.plusMonths(months);
            long days = from.until(to, ChronoUnit.DAYS);
            from = from.plusDays(days);
            long millis = from.until(to, ChronoUnit.MILLIS);
            this.out.months = (int)months;
            this.out.days = (int)days;
            this.out.milliseconds = (int)millis;
        }
    }

    @FunctionTemplate(name="age", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AgeDateToMidnight
    implements DrillSimpleFunc {
        @Param
        DateHolder right;
        @Workspace
        LocalDateTime to;
        @Output
        IntervalHolder out;
        @Inject
        ContextInformation contextInfo;

        @Override
        public void setup() {
            ZoneId zoneId = this.contextInfo.getRootFragmentTimeZone();
            ZonedDateTime zdtStart = this.contextInfo.getQueryStartInstant().atZone(zoneId);
            this.to = zdtStart.truncatedTo(ChronoUnit.DAYS).toLocalDateTime();
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            long months = from.until(this.to, ChronoUnit.MONTHS);
            from = from.plusMonths(months);
            long days = from.until(this.to, ChronoUnit.DAYS);
            from = from.plusDays(days);
            long millis = from.until(this.to, ChronoUnit.MILLIS);
            this.out.months = (int)months;
            this.out.days = (int)days;
            this.out.milliseconds = (int)millis;
        }
    }

    @FunctionTemplate(name="age", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AgeDateToTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder left;
        @Param
        DateHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            long months = from.until(to, ChronoUnit.MONTHS);
            from = from.plusMonths(months);
            long days = from.until(to, ChronoUnit.DAYS);
            from = from.plusDays(days);
            long millis = from.until(to, ChronoUnit.MILLIS);
            this.out.months = (int)months;
            this.out.days = (int)days;
            this.out.milliseconds = (int)millis;
        }
    }

    @FunctionTemplate(name="age", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AgeDateToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder left;
        @Param
        DateHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            long months = from.until(to, ChronoUnit.MONTHS);
            from = from.plusMonths(months);
            long days = from.until(to, ChronoUnit.DAYS);
            from = from.plusDays(days);
            long millis = from.until(to, ChronoUnit.MILLIS);
            this.out.months = (int)months;
            this.out.days = (int)days;
            this.out.milliseconds = (int)millis;
        }
    }

    @FunctionTemplate(name="age", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class AgeDateToDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            LocalDateTime from = Instant.ofEpochMilli(this.right.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            LocalDateTime to = Instant.ofEpochMilli(this.left.value).atZone(ZoneOffset.UTC).toLocalDateTime();
            long months = from.until(to, ChronoUnit.MONTHS);
            from = from.plusMonths(months);
            long days = from.until(to, ChronoUnit.DAYS);
            from = from.plusDays(days);
            long millis = from.until(to, ChronoUnit.MILLIS);
            this.out.months = (int)months;
            this.out.days = (int)days;
            this.out.milliseconds = (int)millis;
        }
    }
}

