/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DivideFunctions {
    static final Logger logger = LoggerFactory.getLogger(DivideFunctions.class);

    @FunctionTemplate(name="divide", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class UInt8UInt8Divide
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in1;
        @Param
        UInt8Holder in2;
        @Output
        UInt8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in1.value / this.in2.value;
        }
    }

    @FunctionTemplate(name="divide", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class UInt4UInt4Divide
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in1;
        @Param
        UInt4Holder in2;
        @Output
        UInt4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in1.value / this.in2.value;
        }
    }

    @FunctionTemplate(name="divide", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class UInt2UInt2Divide
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in1;
        @Param
        UInt2Holder in2;
        @Output
        UInt2Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (char)(this.in1.value / this.in2.value);
        }
    }

    @FunctionTemplate(name="divide", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class UInt1UInt1Divide
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in1;
        @Param
        UInt1Holder in2;
        @Output
        UInt1Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)(this.in1.value / this.in2.value);
        }
    }

    @FunctionTemplate(name="divide", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TinyIntTinyIntDivide
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in1;
        @Param
        TinyIntHolder in2;
        @Output
        TinyIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (byte)(this.in1.value / this.in2.value);
        }
    }

    @FunctionTemplate(name="divide", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SmallIntSmallIntDivide
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in1;
        @Param
        SmallIntHolder in2;
        @Output
        SmallIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (short)(this.in1.value / this.in2.value);
        }
    }

    @FunctionTemplate(name="divide", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Float8Float8Divide
    implements DrillSimpleFunc {
        @Param
        Float8Holder in1;
        @Param
        Float8Holder in2;
        @Output
        Float8Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in1.value / this.in2.value;
        }
    }

    @FunctionTemplate(name="divide", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Float4Float4Divide
    implements DrillSimpleFunc {
        @Param
        Float4Holder in1;
        @Param
        Float4Holder in2;
        @Output
        Float4Holder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in1.value / this.in2.value;
        }
    }

    @FunctionTemplate(name="divide", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class BigIntBigIntDivide
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in1;
        @Param
        BigIntHolder in2;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in1.value / this.in2.value;
        }
    }

    @FunctionTemplate(name="divide", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntIntDivide
    implements DrillSimpleFunc {
        @Param
        IntHolder in1;
        @Param
        IntHolder in2;
        @Output
        IntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in1.value / this.in2.value;
        }
    }
}

