/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.store.PartitionExplorer;
import org.apache.drill.exec.store.PartitionNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryExplorers {
    static final Logger logger = LoggerFactory.getLogger(DirectoryExplorers.class);

    @FunctionTemplate(name="imindir", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class IMinDirTwoArg
    implements DrillSimpleFunc {
        @Param
        VarCharHolder schema;
        @Param
        VarCharHolder table;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        PartitionExplorer partitionExplorer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            Iterable<String> subPartitions;
            try {
                subPartitions = this.partitionExplorer.getSubPartitions(StringFunctionHelpers.getStringFromVarCharHolder(this.schema), StringFunctionHelpers.getStringFromVarCharHolder(this.table), new ArrayList<String>(), new ArrayList<String>());
            }
            catch (PartitionNotFoundException e) {
                throw new RuntimeException(String.format("Error in %s function: Table %s does not exist in schema %s ", "imindir", StringFunctionHelpers.getStringFromVarCharHolder(this.table), StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            Iterator<String> partitionIterator = subPartitions.iterator();
            if (!partitionIterator.hasNext()) {
                throw new RuntimeException(String.format("Error in %s function: Table %s in schema %s does not contain sub-partitions.", "imindir", StringFunctionHelpers.getStringFromVarCharHolder(this.table), StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            String subPartitionStr = partitionIterator.next();
            while (partitionIterator.hasNext()) {
                String curr = partitionIterator.next();
                if (subPartitionStr.compareToIgnoreCase(curr) <= 0) continue;
                subPartitionStr = curr;
            }
            String[] subPartitionParts = subPartitionStr.split("/");
            subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
            byte[] result = subPartitionStr.getBytes(StandardCharsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.buffer.setBytes(0, subPartitionStr.getBytes(StandardCharsets.UTF_8), 0, result.length);
            this.out.start = 0;
            this.out.end = result.length;
        }
    }

    @FunctionTemplate(name="mindir", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class MinDirTwoArg
    implements DrillSimpleFunc {
        @Param
        VarCharHolder schema;
        @Param
        VarCharHolder table;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        PartitionExplorer partitionExplorer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            Iterable<String> subPartitions;
            try {
                subPartitions = this.partitionExplorer.getSubPartitions(StringFunctionHelpers.getStringFromVarCharHolder(this.schema), StringFunctionHelpers.getStringFromVarCharHolder(this.table), new ArrayList<String>(), new ArrayList<String>());
            }
            catch (PartitionNotFoundException e) {
                throw new RuntimeException(String.format("Error in %s function: Table %s does not exist in schema %s ", "mindir", StringFunctionHelpers.getStringFromVarCharHolder(this.table), StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            Iterator<String> partitionIterator = subPartitions.iterator();
            if (!partitionIterator.hasNext()) {
                throw new RuntimeException(String.format("Error in %s function: Table %s in schema %s does not contain sub-partitions.", "mindir", StringFunctionHelpers.getStringFromVarCharHolder(this.table), StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            String subPartitionStr = partitionIterator.next();
            while (partitionIterator.hasNext()) {
                String curr = partitionIterator.next();
                if (subPartitionStr.compareTo(curr) <= 0) continue;
                subPartitionStr = curr;
            }
            String[] subPartitionParts = subPartitionStr.split("/");
            subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
            byte[] result = subPartitionStr.getBytes(StandardCharsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.buffer.setBytes(0, subPartitionStr.getBytes(StandardCharsets.UTF_8), 0, result.length);
            this.out.start = 0;
            this.out.end = result.length;
        }
    }

    @FunctionTemplate(name="imaxdir", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class IMaxDirTwoArg
    implements DrillSimpleFunc {
        @Param
        VarCharHolder schema;
        @Param
        VarCharHolder table;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        PartitionExplorer partitionExplorer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            Iterable<String> subPartitions;
            try {
                subPartitions = this.partitionExplorer.getSubPartitions(StringFunctionHelpers.getStringFromVarCharHolder(this.schema), StringFunctionHelpers.getStringFromVarCharHolder(this.table), new ArrayList<String>(), new ArrayList<String>());
            }
            catch (PartitionNotFoundException e) {
                throw new RuntimeException(String.format("Error in %s function: Table %s does not exist in schema %s ", "imaxdir", StringFunctionHelpers.getStringFromVarCharHolder(this.table), StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            Iterator<String> partitionIterator = subPartitions.iterator();
            if (!partitionIterator.hasNext()) {
                throw new RuntimeException(String.format("Error in %s function: Table %s in schema %s does not contain sub-partitions.", "imaxdir", StringFunctionHelpers.getStringFromVarCharHolder(this.table), StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            String subPartitionStr = partitionIterator.next();
            while (partitionIterator.hasNext()) {
                String curr = partitionIterator.next();
                if (subPartitionStr.compareToIgnoreCase(curr) >= 0) continue;
                subPartitionStr = curr;
            }
            String[] subPartitionParts = subPartitionStr.split("/");
            subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
            byte[] result = subPartitionStr.getBytes(StandardCharsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.buffer.setBytes(0, subPartitionStr.getBytes(StandardCharsets.UTF_8), 0, result.length);
            this.out.start = 0;
            this.out.end = result.length;
        }
    }

    @FunctionTemplate(name="maxdir", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class MaxDirTwoArg
    implements DrillSimpleFunc {
        @Param
        VarCharHolder schema;
        @Param
        VarCharHolder table;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        PartitionExplorer partitionExplorer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            Iterable<String> subPartitions;
            try {
                subPartitions = this.partitionExplorer.getSubPartitions(StringFunctionHelpers.getStringFromVarCharHolder(this.schema), StringFunctionHelpers.getStringFromVarCharHolder(this.table), new ArrayList<String>(), new ArrayList<String>());
            }
            catch (PartitionNotFoundException e) {
                throw new RuntimeException(String.format("Error in %s function: Table %s does not exist in schema %s ", "maxdir", StringFunctionHelpers.getStringFromVarCharHolder(this.table), StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            Iterator<String> partitionIterator = subPartitions.iterator();
            if (!partitionIterator.hasNext()) {
                throw new RuntimeException(String.format("Error in %s function: Table %s in schema %s does not contain sub-partitions.", "maxdir", StringFunctionHelpers.getStringFromVarCharHolder(this.table), StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            String subPartitionStr = partitionIterator.next();
            while (partitionIterator.hasNext()) {
                String curr = partitionIterator.next();
                if (subPartitionStr.compareTo(curr) >= 0) continue;
                subPartitionStr = curr;
            }
            String[] subPartitionParts = subPartitionStr.split("/");
            subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
            byte[] result = subPartitionStr.getBytes(StandardCharsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.buffer.setBytes(0, subPartitionStr.getBytes(StandardCharsets.UTF_8), 0, result.length);
            this.out.start = 0;
            this.out.end = result.length;
        }
    }

    @FunctionTemplate(name="imindir", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class IMinDir
    implements DrillSimpleFunc {
        @Param
        VarCharHolder schema;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        PartitionExplorer partitionExplorer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            Iterable<String> subPartitions;
            try {
                subPartitions = this.partitionExplorer.getSubPartitions(StringFunctionHelpers.getStringFromVarCharHolder(this.schema), ".", new ArrayList<String>(), new ArrayList<String>());
            }
            catch (PartitionNotFoundException e) {
                throw new RuntimeException(String.format("Error in %s function: Schema/table %s does not exist ", "imindir", StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            Iterator<String> partitionIterator = subPartitions.iterator();
            if (!partitionIterator.hasNext()) {
                throw new RuntimeException(String.format("Error in %s function: Schema/table %s does not contain sub-partitions.", "imindir", StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            String subPartitionStr = partitionIterator.next();
            while (partitionIterator.hasNext()) {
                String curr = partitionIterator.next();
                if (subPartitionStr.compareToIgnoreCase(curr) <= 0) continue;
                subPartitionStr = curr;
            }
            String[] subPartitionParts = subPartitionStr.split("/");
            subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
            byte[] result = subPartitionStr.getBytes(StandardCharsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.buffer.setBytes(0, subPartitionStr.getBytes(StandardCharsets.UTF_8), 0, result.length);
            this.out.start = 0;
            this.out.end = result.length;
        }
    }

    @FunctionTemplate(name="mindir", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class MinDir
    implements DrillSimpleFunc {
        @Param
        VarCharHolder schema;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        PartitionExplorer partitionExplorer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            Iterable<String> subPartitions;
            try {
                subPartitions = this.partitionExplorer.getSubPartitions(StringFunctionHelpers.getStringFromVarCharHolder(this.schema), ".", new ArrayList<String>(), new ArrayList<String>());
            }
            catch (PartitionNotFoundException e) {
                throw new RuntimeException(String.format("Error in %s function: Schema/table %s does not exist ", "mindir", StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            Iterator<String> partitionIterator = subPartitions.iterator();
            if (!partitionIterator.hasNext()) {
                throw new RuntimeException(String.format("Error in %s function: Schema/table %s does not contain sub-partitions.", "mindir", StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            String subPartitionStr = partitionIterator.next();
            while (partitionIterator.hasNext()) {
                String curr = partitionIterator.next();
                if (subPartitionStr.compareTo(curr) <= 0) continue;
                subPartitionStr = curr;
            }
            String[] subPartitionParts = subPartitionStr.split("/");
            subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
            byte[] result = subPartitionStr.getBytes(StandardCharsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.buffer.setBytes(0, subPartitionStr.getBytes(StandardCharsets.UTF_8), 0, result.length);
            this.out.start = 0;
            this.out.end = result.length;
        }
    }

    @FunctionTemplate(name="imaxdir", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class IMaxDir
    implements DrillSimpleFunc {
        @Param
        VarCharHolder schema;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        PartitionExplorer partitionExplorer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            Iterable<String> subPartitions;
            try {
                subPartitions = this.partitionExplorer.getSubPartitions(StringFunctionHelpers.getStringFromVarCharHolder(this.schema), ".", new ArrayList<String>(), new ArrayList<String>());
            }
            catch (PartitionNotFoundException e) {
                throw new RuntimeException(String.format("Error in %s function: Schema/table %s does not exist ", "imaxdir", StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            Iterator<String> partitionIterator = subPartitions.iterator();
            if (!partitionIterator.hasNext()) {
                throw new RuntimeException(String.format("Error in %s function: Schema/table %s does not contain sub-partitions.", "imaxdir", StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            String subPartitionStr = partitionIterator.next();
            while (partitionIterator.hasNext()) {
                String curr = partitionIterator.next();
                if (subPartitionStr.compareToIgnoreCase(curr) >= 0) continue;
                subPartitionStr = curr;
            }
            String[] subPartitionParts = subPartitionStr.split("/");
            subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
            byte[] result = subPartitionStr.getBytes(StandardCharsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.buffer.setBytes(0, subPartitionStr.getBytes(StandardCharsets.UTF_8), 0, result.length);
            this.out.start = 0;
            this.out.end = result.length;
        }
    }

    @FunctionTemplate(name="maxdir", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class MaxDir
    implements DrillSimpleFunc {
        @Param
        VarCharHolder schema;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        PartitionExplorer partitionExplorer;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            Iterable<String> subPartitions;
            try {
                subPartitions = this.partitionExplorer.getSubPartitions(StringFunctionHelpers.getStringFromVarCharHolder(this.schema), ".", new ArrayList<String>(), new ArrayList<String>());
            }
            catch (PartitionNotFoundException e) {
                throw new RuntimeException(String.format("Error in %s function: Schema/table %s does not exist ", "maxdir", StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            Iterator<String> partitionIterator = subPartitions.iterator();
            if (!partitionIterator.hasNext()) {
                throw new RuntimeException(String.format("Error in %s function: Schema/table %s does not contain sub-partitions.", "maxdir", StringFunctionHelpers.getStringFromVarCharHolder(this.schema)));
            }
            String subPartitionStr = partitionIterator.next();
            while (partitionIterator.hasNext()) {
                String curr = partitionIterator.next();
                if (subPartitionStr.compareTo(curr) >= 0) continue;
                subPartitionStr = curr;
            }
            String[] subPartitionParts = subPartitionStr.split("/");
            subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
            byte[] result = subPartitionStr.getBytes(StandardCharsets.UTF_8);
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.buffer.setBytes(0, subPartitionStr.getBytes(StandardCharsets.UTF_8), 0, result.length);
            this.out.start = 0;
            this.out.end = result.length;
        }
    }
}

