/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.ops.ContextInformation;
import org.apache.drill.exec.vector.DateUtilities;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTypeFunctions {
    public static long getQueryStartDate(ContextInformation contextInfo) {
        DateTime now = new DateTime(contextInfo.getQueryStartTime()).withZoneRetainFields(DateTimeZone.UTC);
        return now.getMillis();
    }

    @FunctionTemplate(name="unix_timestamp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class UnixTimeStampForDateWithPattern
    implements DrillSimpleFunc {
        @Param
        VarCharHolder inputDateValue;
        @Param
        VarCharHolder inputPattern;
        @Output
        BigIntHolder out;
        @Workspace
        DateTime date;
        @Workspace
        DateTimeFormatter formatter;

        @Override
        public void setup() {
            String pattern = StringFunctionHelpers.toStringFromUTF8(this.inputPattern.start, this.inputPattern.end, this.inputPattern.buffer);
            this.formatter = DateTimeFormat.forPattern((String)pattern);
        }

        @Override
        public void eval() {
            String inputDate = StringFunctionHelpers.toStringFromUTF8(this.inputDateValue.start, this.inputDateValue.end, this.inputDateValue.buffer);
            this.date = this.formatter.parseDateTime(inputDate);
            this.out.value = this.date.getMillis() / 1000L;
        }
    }

    @FunctionTemplate(name="unix_timestamp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class UnixTimeStampForDate
    implements DrillSimpleFunc {
        @Param
        VarCharHolder inputDateValue;
        @Output
        BigIntHolder out;
        @Workspace
        DateTime date;
        @Workspace
        DateTimeFormatter formatter;

        @Override
        public void setup() {
            this.formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        }

        @Override
        public void eval() {
            String inputDate = StringFunctionHelpers.toStringFromUTF8(this.inputDateValue.start, this.inputDateValue.end, this.inputDateValue.buffer);
            this.date = this.formatter.parseDateTime(inputDate);
            this.out.value = this.date.getMillis() / 1000L;
        }
    }

    @FunctionTemplate(name="unix_timestamp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class UnixTimeStamp
    implements DrillSimpleFunc {
        @Output
        BigIntHolder out;
        @Workspace
        long queryStartDate;
        @Inject
        ContextInformation contextInfo;

        @Override
        public void setup() {
            this.queryStartDate = this.contextInfo.getQueryStartTime();
        }

        @Override
        public void eval() {
            this.out.value = this.queryStartDate / 1000L;
        }
    }

    @FunctionTemplate(name="castTIME", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastDateToTime
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        TimeHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = 0;
        }
    }

    @FunctionTemplate(name="castTIMESTAMP", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastTimeToTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeHolder in;
        @Output
        TimeStampHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.value;
        }
    }

    @FunctionTemplate(name="castTIME", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CastTimeStampToTime
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        TimeHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)(this.in.value % 86400000L);
        }
    }

    @FunctionTemplate(names={"date_part"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DatePartFunction
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        DateHolder right;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            throw new UnsupportedOperationException("date_part function should be rewritten as extract() functions");
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimeDateAddFunction
    implements DrillSimpleFunc {
        @Param
        TimeHolder right;
        @Param
        DateHolder left;
        @Output
        TimeStampHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.value + (long)this.right.value;
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DateTimeAddFunction
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        TimeHolder right;
        @Output
        TimeStampHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.value + (long)this.right.value;
        }
    }

    @FunctionTemplate(names={"current_time", "localtime"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, isNiladic=true)
    public static class CurrentTime
    implements DrillSimpleFunc {
        @Workspace
        int queryStartTime;
        @Output
        TimeHolder out;
        @Inject
        ContextInformation contextInfo;

        @Override
        public void setup() {
            Instant queryStart = this.contextInfo.getQueryStartInstant();
            ZonedDateTime lzdt = queryStart.atZone(this.contextInfo.getRootFragmentTimeZone());
            this.queryStartTime = DateUtilities.toDrillTime(lzdt.toLocalTime());
        }

        @Override
        public void eval() {
            this.out.value = this.queryStartTime;
        }
    }

    @FunctionTemplate(names={"now", "statement_timestamp", "transaction_timestamp"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LocalTimeStampNonNiladic
    implements DrillSimpleFunc {
        @Workspace
        long queryStartDate;
        @Output
        TimeStampHolder out;
        @Inject
        ContextInformation contextInfo;

        @Override
        public void setup() {
            this.queryStartDate = DateTypeFunctions.getQueryStartDate(this.contextInfo);
        }

        @Override
        public void eval() {
            this.out.value = this.queryStartDate;
        }
    }

    @FunctionTemplate(names={"localtimestamp", "current_timestamp"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, isNiladic=true)
    public static class LocalTimeStampNiladic
    implements DrillSimpleFunc {
        @Workspace
        long queryStartDate;
        @Output
        TimeStampHolder out;
        @Inject
        ContextInformation contextInfo;

        @Override
        public void setup() {
            this.queryStartDate = DateTypeFunctions.getQueryStartDate(this.contextInfo);
        }

        @Override
        public void eval() {
            this.out.value = this.queryStartDate;
        }
    }

    @FunctionTemplate(name="timeofday", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, isRandom=true, outputSizeEstimate=100)
    public static class TimeOfDay
    implements DrillSimpleFunc {
        @Inject
        DrillBuf buffer;
        @Output
        VarCharHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            ZonedDateTime temp = ZonedDateTime.now();
            String str = DateUtility.formatTimeStampTZ.format(temp);
            this.out.buffer = this.buffer;
            this.out.start = 0;
            this.out.end = Math.min(100, str.length());
            this.out.buffer.setBytes(0, str.substring(0, this.out.end).getBytes(StandardCharsets.UTF_8));
        }
    }

    @FunctionTemplate(name="current_date", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, isNiladic=true)
    public static class CurrentDate
    implements DrillSimpleFunc {
        @Workspace
        long queryStartDate;
        @Output
        DateHolder out;
        @Inject
        ContextInformation contextInfo;

        @Override
        public void setup() {
            Instant queryStart = this.contextInfo.getQueryStartInstant();
            ZonedDateTime lzdt = queryStart.atZone(this.contextInfo.getRootFragmentTimeZone());
            LocalDate ld = lzdt.truncatedTo(ChronoUnit.DAYS).toLocalDate();
            this.queryStartDate = DateUtilities.toDrillDate(ld);
        }

        @Override
        public void eval() {
            this.out.value = this.queryStartDate;
        }
    }

    @FunctionTemplate(name="timetype", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimeType
    implements DrillSimpleFunc {
        @Param
        BigIntHolder inputHours;
        @Param
        BigIntHolder inputMinutes;
        @Param
        BigIntHolder inputSeconds;
        @Param
        BigIntHolder inputMilliSeconds;
        @Output
        TimeHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)(this.inputHours.value * 3600000L + this.inputMinutes.value * 60000L + this.inputSeconds.value * 1000L + this.inputMilliSeconds.value);
        }
    }

    @FunctionTemplate(name="timestamptype", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class TimeStampType
    implements DrillSimpleFunc {
        @Param
        BigIntHolder inputYears;
        @Param
        BigIntHolder inputMonths;
        @Param
        BigIntHolder inputDays;
        @Param
        BigIntHolder inputHours;
        @Param
        BigIntHolder inputMinutes;
        @Param
        BigIntHolder inputSeconds;
        @Param
        BigIntHolder inputMilliSeconds;
        @Output
        TimeStampHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = new MutableDateTime((int)this.inputYears.value, (int)this.inputMonths.value, (int)this.inputDays.value, (int)this.inputHours.value, (int)this.inputMinutes.value, (int)this.inputSeconds.value, (int)this.inputMilliSeconds.value, DateTimeZone.UTC).getMillis();
        }
    }

    @FunctionTemplate(name="datetype", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DateType
    implements DrillSimpleFunc {
        @Param
        BigIntHolder inputYears;
        @Param
        BigIntHolder inputMonths;
        @Param
        BigIntHolder inputDays;
        @Output
        DateHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = new MutableDateTime((int)this.inputYears.value, (int)this.inputMonths.value, (int)this.inputDays.value, 0, 0, 0, 0, DateTimeZone.UTC).getMillis();
        }
    }

    @FunctionTemplate(name="interval_day", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalDayType
    implements DrillSimpleFunc {
        @Param
        BigIntHolder inputDays;
        @Param
        BigIntHolder inputHours;
        @Param
        BigIntHolder inputMinutes;
        @Param
        BigIntHolder inputSeconds;
        @Param
        BigIntHolder inputMillis;
        @Output
        IntervalDayHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.days = (int)this.inputDays.value;
            this.out.milliseconds = (int)(this.inputHours.value * 3600000L + this.inputMinutes.value * 60000L + this.inputSeconds.value * 1000L + this.inputMillis.value);
        }
    }

    @FunctionTemplate(name="interval_year", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalYearType
    implements DrillSimpleFunc {
        @Param
        BigIntHolder inputYears;
        @Param
        BigIntHolder inputMonths;
        @Output
        IntervalYearHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = (int)(this.inputYears.value * 12L + this.inputMonths.value);
        }
    }

    @FunctionTemplate(name="intervaltype", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalType
    implements DrillSimpleFunc {
        @Param
        BigIntHolder inputYears;
        @Param
        BigIntHolder inputMonths;
        @Param
        BigIntHolder inputDays;
        @Param
        BigIntHolder inputHours;
        @Param
        BigIntHolder inputMinutes;
        @Param
        BigIntHolder inputSeconds;
        @Param
        BigIntHolder inputMilliSeconds;
        @Output
        IntervalHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.months = (int)(this.inputYears.value * 12L + this.inputMonths.value);
            this.out.days = (int)this.inputDays.value;
            this.out.milliseconds = (int)(this.inputHours.value * 3600000L + this.inputMinutes.value * 60000L + this.inputSeconds.value * 1000L + this.inputMilliSeconds.value);
        }
    }

    @FunctionTemplate(name="isdate", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL, costCategory=FunctionTemplate.FunctionCostCategory.COMPLEX)
    public static class IsDateRequiredInput
    implements DrillSimpleFunc {
        @Param
        VarCharHolder in;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = StringFunctionHelpers.isReadableAsDate(this.in.buffer, this.in.start, this.in.end) ? 1 : 0;
        }
    }

    @FunctionTemplate(name="isdate", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL, costCategory=FunctionTemplate.FunctionCostCategory.COMPLEX)
    public static class IsDate
    implements DrillSimpleFunc {
        @Param
        NullableVarCharHolder in;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.in.isSet == 0 ? 0 : (StringFunctionHelpers.isReadableAsDate(this.in.buffer, this.in.start, this.in.end) ? 1 : 0);
        }
    }
}

