/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;

public class DateIntervalDayFunctions {

    @FunctionTemplate(names={"date_sub", "subtract", "date_diff"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DateIntervalDaySubtractFunction
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        IntervalDayHolder right;
        @Workspace
        MutableDateTime temp;
        @Output
        DateHolder out;

        @Override
        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addDays(this.right.days * -1);
            this.temp.add((long)(this.right.milliseconds * -1));
            this.out.value = this.temp.getMillis();
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalDayDateAddFunction
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder right;
        @Param
        DateHolder left;
        @Workspace
        MutableDateTime temp;
        @Output
        TimeStampHolder out;

        @Override
        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addDays(this.right.days);
            this.temp.add((long)this.right.milliseconds);
            this.out.value = this.temp.getMillis();
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DateIntervalDayAddFunction
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        IntervalDayHolder right;
        @Workspace
        MutableDateTime temp;
        @Output
        TimeStampHolder out;

        @Override
        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        @Override
        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addDays(this.right.days);
            this.temp.add((long)this.right.milliseconds);
            this.out.value = this.temp.getMillis();
        }
    }
}

