/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.ops.ContextInformation;

public class ContextFunctions {

    @FunctionTemplate(name="session_id", scope=FunctionTemplate.FunctionScope.SIMPLE, isNiladic=true, outputSizeEstimate=32)
    public static class SessionId
    implements DrillSimpleFunc {
        @Output
        VarCharHolder out;
        @Inject
        ContextInformation contextInfo;
        @Inject
        DrillBuf buffer;
        @Workspace
        int sessionIdBytesLength;

        @Override
        public void setup() {
            byte[] sessionIdBytes = this.contextInfo.getSessionId().getBytes(StandardCharsets.UTF_8);
            this.buffer = this.buffer.reallocIfNeeded(sessionIdBytes.length);
            this.sessionIdBytesLength = sessionIdBytes.length;
            this.buffer.setBytes(0, sessionIdBytes);
        }

        @Override
        public void eval() {
            this.out.start = 0;
            this.out.end = this.sessionIdBytesLength;
            this.out.buffer = this.buffer;
        }
    }

    @FunctionTemplate(name="current_schema", scope=FunctionTemplate.FunctionScope.SIMPLE, isNiladic=true, outputSizeEstimate=1024)
    public static class CurrentSchema
    implements DrillSimpleFunc {
        @Output
        VarCharHolder out;
        @Inject
        ContextInformation contextInfo;
        @Inject
        DrillBuf buffer;
        @Workspace
        int currentSchemaBytesLength;

        @Override
        public void setup() {
            byte[] currentSchemaBytes = this.contextInfo.getCurrentDefaultSchema().getBytes(StandardCharsets.UTF_8);
            this.buffer = this.buffer.reallocIfNeeded(currentSchemaBytes.length);
            this.currentSchemaBytesLength = currentSchemaBytes.length;
            this.buffer.setBytes(0, currentSchemaBytes);
        }

        @Override
        public void eval() {
            this.out.start = 0;
            this.out.end = this.currentSchemaBytesLength;
            this.out.buffer = this.buffer;
        }
    }

    @FunctionTemplate(names={"user", "session_user", "system_user"}, scope=FunctionTemplate.FunctionScope.SIMPLE, isNiladic=true, outputSizeEstimate=32)
    public static class User
    implements DrillSimpleFunc {
        @Output
        VarCharHolder out;
        @Inject
        ContextInformation contextInfo;
        @Inject
        DrillBuf buffer;
        @Workspace
        int queryUserBytesLength;

        @Override
        public void setup() {
            byte[] queryUserNameBytes = this.contextInfo.getQueryUser().getBytes(StandardCharsets.UTF_8);
            this.buffer = this.buffer.reallocIfNeeded(queryUserNameBytes.length);
            this.queryUserBytesLength = queryUserNameBytes.length;
            this.buffer.setBytes(0, queryUserNameBytes);
        }

        @Override
        public void eval() {
            this.out.start = 0;
            this.out.end = this.queryUserBytesLength;
            this.out.buffer = this.buffer;
        }
    }
}

