/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.vector.complex.MapUtility;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;

@FunctionTemplate(name="collect_list", isVarArg=true, isInternal=true, scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public class CollectListMapsAggFunction
implements DrillAggFunc {
    @Param
    FieldReader[] inputs;
    @Output
    BaseWriter.ComplexWriter writer;
    @Workspace
    ObjectHolder writerHolder;

    @Override
    public void setup() {
        this.writerHolder = new ObjectHolder();
    }

    @Override
    public void add() {
        if (this.writerHolder.obj == null) {
            this.writerHolder.obj = this.writer.rootAsList();
        }
        BaseWriter.ListWriter listWriter = (BaseWriter.ListWriter)this.writerHolder.obj;
        BaseWriter.MapWriter mapWriter = listWriter.map();
        mapWriter.start();
        for (int i = 0; i < this.inputs.length; i += 2) {
            MapUtility.writeToMapFromReader(this.inputs[i + 1], mapWriter, this.inputs[i].readText().toString(), "CollectListMapsAggFunction");
        }
        mapWriter.end();
    }

    @Override
    public void output() {
        ((BaseWriter.ListWriter)this.writerHolder.obj).endList();
    }

    @Override
    public void reset() {
        this.writerHolder.obj = null;
    }
}

