/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

@FunctionTemplate(names={"charsubstring", "substring2", "substr2"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CLONE)
public class CharSubstring
implements DrillSimpleFunc {
    @Param
    VarCharHolder string;
    @Param
    BigIntHolder offset;
    @Param
    BigIntHolder length;
    @Output
    VarCharHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
        this.out.buffer = this.string.buffer;
        if (this.offset.value == 0L || this.length.value <= 0L) {
            this.out.start = 0;
            this.out.end = 0;
        } else {
            byte currentByte;
            int byteCount;
            int charCount = 0;
            int byteStart = 0;
            int charStart = 0;
            int byteEnd = 0;
            for (byteCount = 0; byteCount < this.string.end - this.string.start; ++byteCount) {
                currentByte = this.string.buffer.getByte(this.string.start + byteCount);
                if (this.offset.value > 0L && charCount == (int)this.offset.value - 1) {
                    byteStart = byteCount;
                    charStart = charCount;
                }
                if (this.offset.value > 0L && charCount - charStart == (int)this.length.value) {
                    byteEnd = byteCount;
                    break;
                }
                if (currentByte >= 128) continue;
                ++charCount;
            }
            this.out.start = this.string.start + byteStart;
            this.out.end = this.string.start + byteEnd;
            if (this.offset.value < 0L) {
                int endBytePos = --byteCount;
                int endCharPos = --charCount;
                block1: while (byteCount >= 0) {
                    currentByte = this.string.buffer.getByte(byteCount);
                    if (endCharPos - charCount == -((int)this.offset.value)) {
                        this.out.start = byteCount;
                        charCount = 0;
                        while (byteCount <= endBytePos) {
                            currentByte = this.string.buffer.getByte(byteCount);
                            if (currentByte < 128) {
                                ++charCount;
                            }
                            ++byteCount;
                            if (charCount != (int)this.length.value) continue;
                            this.out.end = byteCount;
                            break block1;
                        }
                        break;
                    }
                    if (currentByte < 128) {
                        --charCount;
                    }
                    --byteCount;
                }
            }
            if (this.out.end == 0) {
                this.out.end = this.string.end;
            }
        }
    }
}

