/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;

public class ByteArrayFunctions {
    private ByteArrayFunctions() {
    }

    @FunctionTemplate(name="length", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ByteArrLength
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder input;
        @Output
        BigIntHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.input.end - this.input.start;
        }
    }

    @FunctionTemplate(names={"bytesubstring", "byte_substr"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, outputWidthCalculatorType=FunctionTemplate.OutputWidthCalculatorType.CUSTOM_CLONE_DEFAULT)
    public static class ByteSubstring
    implements DrillSimpleFunc {
        @Param
        VarBinaryHolder in;
        @Param
        BigIntHolder offset;
        @Param
        BigIntHolder length;
        @Output
        VarBinaryHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.buffer = this.in.buffer;
            if (this.offset.value == 0L || this.length.value <= 0L) {
                this.out.start = 0;
                this.out.end = 0;
            } else {
                this.out.start = this.offset.value < 0L ? this.in.end + (int)this.offset.value : this.in.start + (int)this.offset.value - 1;
                this.out.end = (long)this.out.start + this.length.value > (long)this.in.end ? this.in.end : this.out.start + (int)this.length.value;
            }
        }
    }
}

