/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanAggrFunctions {
    static final Logger logger = LoggerFactory.getLogger(BooleanAggrFunctions.class);

    @FunctionTemplate(name="bool_and", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBitBooleanAnd
    implements DrillAggFunc {
        @Param
        NullableBitHolder in;
        @Workspace
        BitHolder inter;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.inter = new BitHolder();
            this.inter.value = Integer.MAX_VALUE;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.inter.value &= this.in.value;
            }
        }

        @Override
        public void output() {
            this.out.value = this.inter.value;
        }

        @Override
        public void reset() {
            this.inter.value = Integer.MAX_VALUE;
        }
    }

    @FunctionTemplate(name="bool_and", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BitBooleanAnd
    implements DrillAggFunc {
        @Param
        BitHolder in;
        @Workspace
        BitHolder inter;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.inter = new BitHolder();
            this.inter.value = Integer.MAX_VALUE;
        }

        @Override
        public void add() {
            this.inter.value &= this.in.value;
        }

        @Override
        public void output() {
            this.out.value = this.inter.value;
        }

        @Override
        public void reset() {
            this.inter.value = Integer.MAX_VALUE;
        }
    }

    @FunctionTemplate(name="bool_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBitBooleanOr
    implements DrillAggFunc {
        @Param
        NullableBitHolder in;
        @Workspace
        BitHolder inter;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.inter = new BitHolder();
            this.inter.value = 0;
        }

        @Override
        public void add() {
            if (this.in.isSet != 0) {
                this.inter.value |= this.in.value;
            }
        }

        @Override
        public void output() {
            this.out.value = this.inter.value;
        }

        @Override
        public void reset() {
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bool_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BitBooleanOr
    implements DrillAggFunc {
        @Param
        BitHolder in;
        @Workspace
        BitHolder inter;
        @Output
        BitHolder out;

        @Override
        public void setup() {
            this.inter = new BitHolder();
            this.inter.value = 0;
        }

        @Override
        public void add() {
            this.inter.value |= this.in.value;
        }

        @Override
        public void output() {
            this.out.value = this.inter.value;
        }

        @Override
        public void reset() {
            this.inter.value = 0;
        }
    }
}

