/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BitHolder;

public class BitFunctions {

    @FunctionTemplate(names={"booleanAnd", "and", "&&"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class BitAnd
    implements DrillSimpleFunc {
        @Param
        BitHolder left;
        @Param
        BitHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.value & this.right.value;
        }
    }

    @FunctionTemplate(names={"booleanOr", "or", "||", "orNoShortCircuit"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class BitOr
    implements DrillSimpleFunc {
        @Param
        BitHolder left;
        @Param
        BitHolder right;
        @Output
        BitHolder out;

        @Override
        public void setup() {
        }

        @Override
        public void eval() {
            this.out.value = this.left.value | this.right.value;
        }
    }
}

