/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.fn.impl.SqlPatternMatcher;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqlPatternMatcher
implements SqlPatternMatcher {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSqlPatternMatcher.class);
    protected final String patternString;
    protected final int patternLength;
    protected final ByteBuffer patternByteBuffer;

    public AbstractSqlPatternMatcher(String patternString) {
        this.patternString = patternString;
        CharsetEncoder charsetEncoder = Charsets.UTF_8.newEncoder();
        CharBuffer patternCharBuffer = CharBuffer.wrap(patternString);
        try {
            this.patternByteBuffer = charsetEncoder.encode(patternCharBuffer);
        }
        catch (CharacterCodingException e) {
            throw UserException.validationError(e).message("Failure to encode pattern %s using UTF-8", patternString).addContext("Message: ", e.getMessage()).build(logger);
        }
        this.patternLength = this.patternByteBuffer.limit();
    }
}

