/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Unparser;
import org.codehaus.janino.util.AbstractTraverser;
import org.codehaus.janino.util.DeepCopier;

public class MethodGrabbingVisitor {
    private final Class<?> clazz;
    private final Map<String, String> methods = new HashMap<String, String>();
    private final ClassFinder classFinder = new ClassFinder();
    private boolean captureMethods = false;

    private MethodGrabbingVisitor(Class<?> clazz) {
        this.clazz = clazz;
    }

    public static Map<String, String> getMethods(Java.CompilationUnit compilationUnit, Class<?> clazz) {
        MethodGrabbingVisitor visitor = new MethodGrabbingVisitor(clazz);
        visitor.classFinder.visitTypeDeclaration((Java.TypeDeclaration)compilationUnit.getPackageMemberTypeDeclarations()[0]);
        return visitor.methods;
    }

    public class ClassFinder
    extends AbstractTraverser<RuntimeException> {
        public void traverseClassDeclaration(Java.AbstractClassDeclaration classDeclaration) {
            boolean prevCapture = MethodGrabbingVisitor.this.captureMethods;
            MethodGrabbingVisitor.this.captureMethods = MethodGrabbingVisitor.this.clazz.getName().equals(classDeclaration.getClassName());
            super.traverseClassDeclaration(classDeclaration);
            MethodGrabbingVisitor.this.captureMethods = prevCapture;
        }

        public void traverseMethodDeclarator(Java.MethodDeclarator methodDeclarator) {
            if (MethodGrabbingVisitor.this.captureMethods) {
                String[] fQCN = methodDeclarator.getDeclaringType().getClassName().split("\\.");
                final String returnLabel = fQCN[fQCN.length - 1] + "_" + methodDeclarator.name;
                Java.Block methodBodyBlock = new Java.Block(methodDeclarator.getLocation());
                DeepCopier returnStatementReplacer = new DeepCopier(){

                    public Java.BlockStatement copyReturnStatement(Java.ReturnStatement subject) {
                        return new Java.BreakStatement(subject.getLocation(), returnLabel);
                    }
                };
                try {
                    methodBodyBlock.addStatements(returnStatementReplacer.copyBlockStatements((Collection)methodDeclarator.statements));
                }
                catch (CompileException e) {
                    throw new RuntimeException(e);
                }
                Java.LabeledStatement labeledStatement = new Java.LabeledStatement(methodDeclarator.getLocation(), returnLabel, (Java.Statement)methodBodyBlock);
                StringWriter writer = new StringWriter();
                Unparser unparser = new Unparser((Writer)writer);
                unparser.unparseBlockStatement((Java.BlockStatement)labeledStatement);
                unparser.close();
                writer.flush();
                MethodGrabbingVisitor.this.methods.put(methodDeclarator.name, writer.getBuffer().toString());
            }
        }
    }
}

