/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.janino.Java;
import org.codehaus.janino.util.AbstractTraverser;

public class ImportGrabber {
    private final List<String> imports = new ArrayList<String>();
    private final ImportFinder importFinder = new ImportFinder();

    private ImportGrabber() {
    }

    public static List<String> getImports(Java.CompilationUnit compilationUnit) {
        ImportGrabber visitor = new ImportGrabber();
        Arrays.stream(compilationUnit.importDeclarations).forEach(arg_0 -> ((ImportFinder)visitor.importFinder).visitImportDeclaration(arg_0));
        return visitor.imports;
    }

    public class ImportFinder
    extends AbstractTraverser<RuntimeException> {
        public void traverseSingleTypeImportDeclaration(Java.AbstractCompilationUnit.SingleTypeImportDeclaration stid) {
            ImportGrabber.this.imports.add(stid.toString());
        }

        public void traverseSingleStaticImportDeclaration(Java.AbstractCompilationUnit.SingleStaticImportDeclaration stid) {
            ImportGrabber.this.imports.add(stid.toString());
        }

        public void traverseTypeImportOnDemandDeclaration(Java.AbstractCompilationUnit.TypeImportOnDemandDeclaration tiodd) {
            ImportGrabber.this.imports.add(tiodd.toString());
        }

        public void traverseStaticImportOnDemandDeclaration(Java.AbstractCompilationUnit.StaticImportOnDemandDeclaration siodd) {
            ImportGrabber.this.imports.add(siodd.toString());
        }
    }
}

