/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.fn.ImportGrabber;
import org.apache.drill.exec.expr.fn.MethodGrabbingVisitor;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.eclipse.jetty.util.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionInitializer {
    private static final Logger logger = LoggerFactory.getLogger(FunctionInitializer.class);
    private final String className;
    private final ClassLoader classLoader;
    private Map<String, String> methods;
    private List<String> imports;
    private volatile boolean isLoaded;

    public FunctionInitializer(String className, ClassLoader classLoader) {
        this.className = className;
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getClassName() {
        return this.className;
    }

    public List<String> getImports() {
        this.loadFunctionBody();
        return this.imports;
    }

    public String getMethod(String methodName) {
        this.loadFunctionBody();
        return this.methods.get(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFunctionBody() {
        if (this.isLoaded) {
            return;
        }
        FunctionInitializer functionInitializer = this;
        synchronized (functionInitializer) {
            if (this.isLoaded) {
                return;
            }
            logger.trace("Getting function body for the {}", (Object)this.className);
            try {
                Class<?> clazz = Class.forName(this.className, true, this.classLoader);
                Java.CompilationUnit cu = this.convertToCompilationUnit(clazz);
                this.methods = MethodGrabbingVisitor.getMethods(cu, clazz);
                this.imports = ImportGrabber.getImports(cu);
                this.isLoaded = true;
            }
            catch (IOException | ClassNotFoundException e) {
                throw UserException.functionError(e).message("Failure reading Function class.", new Object[0]).addContext("Function Class", this.className).build(logger);
            }
        }
    }

    @VisibleForTesting
    Java.CompilationUnit convertToCompilationUnit(Class<?> clazz) throws IOException {
        String path = clazz.getName();
        path = path.replaceFirst("\\$.*", "");
        path = path.replace(".", "/");
        path = "/" + path + ".java";
        logger.trace("Loading function code from the {}", (Object)path);
        try (InputStream is = clazz.getResourceAsStream(path);){
            if (is == null) {
                throw new IOException(String.format("Failure trying to locate source code for class %s, tried to read on classpath location %s", clazz.getName(), path));
            }
            String body = IO.toString((InputStream)is);
            body = body.replaceAll("@\\w+(?:\\([^\\\\]*?\\))?", "");
            try {
                Java.CompilationUnit compilationUnit = (Java.CompilationUnit)new Parser(new Scanner(null, (Reader)new StringReader(body))).parseAbstractCompilationUnit();
                return compilationUnit;
            }
            catch (CompileException e) {
                throw new IOException(String.format("Failure while loading class %s.", clazz.getName()), e);
            }
        }
    }
}

