/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.fn.FunctionReplacementUtils;
import org.apache.drill.common.scanner.ClassPathScanner;
import org.apache.drill.common.scanner.RunTimeScan;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.coord.store.TransientStoreEvent;
import org.apache.drill.exec.coord.store.TransientStoreListener;
import org.apache.drill.exec.exception.FunctionValidationException;
import org.apache.drill.exec.exception.JarValidationException;
import org.apache.drill.exec.expr.fn.AbstractFuncHolder;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionLookupContext;
import org.apache.drill.exec.expr.fn.PluggableFunctionRegistry;
import org.apache.drill.exec.expr.fn.registry.FunctionHolder;
import org.apache.drill.exec.expr.fn.registry.JarScan;
import org.apache.drill.exec.expr.fn.registry.LocalFunctionRegistry;
import org.apache.drill.exec.expr.fn.registry.RemoteFunctionRegistry;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.resolver.FunctionResolver;
import org.apache.drill.exec.resolver.FunctionResolverFactory;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.store.sys.store.DataChangeVersion;
import org.apache.drill.exec.util.JarUtil;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionImplementationRegistry
implements FunctionLookupContext,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(FunctionImplementationRegistry.class);
    private final LocalFunctionRegistry localFunctionRegistry;
    private final RemoteFunctionRegistry remoteFunctionRegistry;
    private final Path localUdfDir;
    private boolean deleteTmpDir;
    private File tmpDir;
    private final List<PluggableFunctionRegistry> pluggableFuncRegistries = new ArrayList<PluggableFunctionRegistry>();
    private OptionSet optionManager;
    private final boolean useDynamicUdfs;

    @VisibleForTesting
    public FunctionImplementationRegistry(DrillConfig config) {
        this(config, ClassPathScanner.fromPrescan(config));
    }

    public FunctionImplementationRegistry(DrillConfig config, ScanResult classpathScan) {
        this(config, classpathScan, null);
    }

    public FunctionImplementationRegistry(DrillConfig config, ScanResult classpathScan, OptionManager optionManager) {
        Stopwatch w = Stopwatch.createStarted();
        logger.debug("Generating function registry.");
        this.optionManager = optionManager;
        this.useDynamicUdfs = !config.getBoolean("drill.exec.udf.disable_dynamic");
        this.localFunctionRegistry = new LocalFunctionRegistry(classpathScan);
        Set<Class<PluggableFunctionRegistry>> registryClasses = classpathScan.getImplementations(PluggableFunctionRegistry.class);
        block2: for (Class<PluggableFunctionRegistry> clazz : registryClasses) {
            for (Constructor<?> c : clazz.getConstructors()) {
                Class<?>[] params = c.getParameterTypes();
                if (params.length == 1 && params[0] == DrillConfig.class) {
                    try {
                        PluggableFunctionRegistry registry = (PluggableFunctionRegistry)c.newInstance(config);
                        this.pluggableFuncRegistries.add(registry);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                        logger.warn("Unable to instantiate PluggableFunctionRegistry class '{}'. Skipping it.", clazz, (Object)e);
                    }
                    continue block2;
                }
                logger.warn("Skipping PluggableFunctionRegistry constructor {} for class {} since it doesn't implement a [constructor(DrillConfig)]", c, clazz);
            }
        }
        logger.info("Function registry loaded.  {} functions loaded in {} ms.", (Object)this.localFunctionRegistry.size(), (Object)w.elapsed(TimeUnit.MILLISECONDS));
        this.remoteFunctionRegistry = new RemoteFunctionRegistry(new UnregistrationListener());
        this.localUdfDir = this.getLocalUdfDir(config);
    }

    public FunctionImplementationRegistry(DrillConfig config, ScanResult classpathScan, OptionSet optionManager) {
        this(config, classpathScan);
        this.optionManager = optionManager;
    }

    public void register(DrillOperatorTable operatorTable) {
        this.localFunctionRegistry.register(operatorTable);
        for (PluggableFunctionRegistry registry : this.pluggableFuncRegistries) {
            registry.register(operatorTable);
        }
    }

    @Override
    public DrillFuncHolder findDrillFunction(FunctionResolver functionResolver, FunctionCall functionCall) {
        List<DrillFuncHolder> functions;
        AtomicInteger version = new AtomicInteger();
        String newFunctionName = this.functionReplacement(functionCall);
        if (this.useDynamicUdfs) {
            functions = this.localFunctionRegistry.getMethods(newFunctionName, version);
            FunctionResolver exactResolver = FunctionResolverFactory.getExactResolver(functionCall);
            DrillFuncHolder holder = exactResolver.getBestMatch(functions, functionCall);
            if (holder != null) {
                return holder;
            }
            this.syncWithRemoteRegistry(version.get());
        }
        functions = this.localFunctionRegistry.getMethods(newFunctionName, version);
        return functionResolver.getBestMatch(functions, functionCall);
    }

    private String functionReplacement(FunctionCall functionCall) {
        boolean castEmptyStringToNull;
        String funcName = functionCall.getName();
        if (functionCall.argCount() == 0) {
            return funcName;
        }
        boolean bl = castEmptyStringToNull = this.optionManager != null && this.optionManager.getOption(ExecConstants.CAST_EMPTY_STRING_TO_NULL_OPTION);
        if (!castEmptyStringToNull) {
            return funcName;
        }
        TypeProtos.MajorType majorType = functionCall.arg(0).getMajorType();
        TypeProtos.DataMode dataMode = majorType.getMode();
        TypeProtos.MinorType minorType = majorType.getMinorType();
        if (FunctionReplacementUtils.isReplacementNeeded(funcName, minorType)) {
            funcName = FunctionReplacementUtils.getReplacingFunction(funcName, dataMode, minorType);
        }
        return funcName;
    }

    public DrillFuncHolder findExactMatchingDrillFunction(String name, List<TypeProtos.MajorType> argTypes, TypeProtos.MajorType returnType) {
        return this.findExactMatchingDrillFunction(name, argTypes, returnType, this.useDynamicUdfs);
    }

    private DrillFuncHolder findExactMatchingDrillFunction(String name, List<TypeProtos.MajorType> argTypes, TypeProtos.MajorType returnType, boolean retry) {
        AtomicInteger version = new AtomicInteger();
        for (DrillFuncHolder h : this.localFunctionRegistry.getMethods(name, version)) {
            if (!h.matches(returnType, argTypes)) continue;
            return h;
        }
        if (retry && this.syncWithRemoteRegistry(version.get())) {
            return this.findExactMatchingDrillFunction(name, argTypes, returnType, false);
        }
        return null;
    }

    @Override
    public AbstractFuncHolder findNonDrillFunction(FunctionCall functionCall) {
        for (PluggableFunctionRegistry registry : this.pluggableFuncRegistries) {
            AbstractFuncHolder h = registry.getFunction(functionCall);
            if (h == null) continue;
            return h;
        }
        return null;
    }

    public boolean isFunctionComplexOutput(String name) {
        List<DrillFuncHolder> methods = this.localFunctionRegistry.getMethods(name);
        for (DrillFuncHolder holder : methods) {
            if (!holder.getReturnValue().isComplexWriter()) continue;
            return true;
        }
        return false;
    }

    public LocalFunctionRegistry getLocalFunctionRegistry() {
        return this.localFunctionRegistry;
    }

    public RemoteFunctionRegistry getRemoteFunctionRegistry() {
        return this.remoteFunctionRegistry;
    }

    public List<String> validate(Path path) throws IOException {
        URL url = path.toUri().toURL();
        URL[] urls = new URL[]{url};
        try (URLClassLoader classLoader = new URLClassLoader(urls);){
            ScanResult jarScanResult = this.scan(classLoader, path, urls);
            List<String> functions = this.localFunctionRegistry.validate(path.getName(), jarScanResult);
            if (functions.isEmpty()) {
                throw new FunctionValidationException(String.format("Jar %s does not contain functions", path.getName()));
            }
            List<String> list = functions;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncWithRemoteRegistry(int version) {
        if (this.isRegistrySyncNeeded()) {
            FunctionImplementationRegistry functionImplementationRegistry = this;
            synchronized (functionImplementationRegistry) {
                int localRegistryVersion = this.localFunctionRegistry.getVersion();
                if (this.isRegistrySyncNeeded(this.remoteFunctionRegistry.getRegistryVersion(), localRegistryVersion)) {
                    DataChangeVersion remoteVersion = new DataChangeVersion();
                    List<String> missingJars = this.getMissingJars(this.remoteFunctionRegistry, this.localFunctionRegistry, remoteVersion);
                    ArrayList<JarScan> jars = new ArrayList<JarScan>();
                    if (!missingJars.isEmpty()) {
                        logger.info("Starting dynamic UDFs lazy-init process.\nThe following jars are going to be downloaded and registered locally: " + missingJars);
                        for (String jarName : missingJars) {
                            Path binary = null;
                            Path source = null;
                            URLClassLoader classLoader = null;
                            try {
                                binary = this.copyJarToLocal(jarName, this.remoteFunctionRegistry);
                                source = this.copyJarToLocal(JarUtil.getSourceName(jarName), this.remoteFunctionRegistry);
                                URL[] urls = new URL[]{binary.toUri().toURL(), source.toUri().toURL()};
                                classLoader = new URLClassLoader(urls);
                                ScanResult scanResult = this.scan(classLoader, binary, urls);
                                this.localFunctionRegistry.validate(jarName, scanResult);
                                jars.add(new JarScan(jarName, scanResult, classLoader));
                            }
                            catch (Exception e) {
                                this.deleteQuietlyLocalJar(binary);
                                this.deleteQuietlyLocalJar(source);
                                if (classLoader != null) {
                                    try {
                                        classLoader.close();
                                    }
                                    catch (Exception ex) {
                                        logger.warn("Problem during closing class loader for {}", (Object)jarName, (Object)e);
                                    }
                                }
                                logger.error("Problem during remote functions load from {}", (Object)jarName, (Object)e);
                            }
                        }
                    }
                    int latestRegistryVersion = jars.size() != missingJars.size() ? localRegistryVersion : remoteVersion.getVersion();
                    this.localFunctionRegistry.register(jars, latestRegistryVersion);
                    return true;
                }
            }
        }
        return version != this.localFunctionRegistry.getVersion();
    }

    private boolean isRegistrySyncNeeded() {
        logger.trace("Has remote function registry: {}", (Object)this.remoteFunctionRegistry.hasRegistry());
        return this.remoteFunctionRegistry.hasRegistry() && this.isRegistrySyncNeeded(this.remoteFunctionRegistry.getRegistryVersion(), this.localFunctionRegistry.getVersion());
    }

    private boolean isRegistrySyncNeeded(int remoteVersion, int localVersion) {
        logger.trace("Compare remote [{}] and local [{}] registry versions.", (Object)remoteVersion, (Object)localVersion);
        return remoteVersion == -2 || remoteVersion != -1 && remoteVersion != localVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScanResult scan(ClassLoader classLoader, Path path, URL[] urls) throws IOException {
        Enumeration<URL> markerFileEnumeration = classLoader.getResources("drill-module.conf");
        while (markerFileEnumeration.hasMoreElements()) {
            URL markerFile = markerFileEnumeration.nextElement();
            if (!markerFile.getPath().contains(path.toUri().getPath())) continue;
            URLConnection markerFileConnection = null;
            try {
                markerFileConnection = markerFile.openConnection();
                DrillConfig drillConfig = DrillConfig.create(ConfigFactory.parseURL((URL)markerFile));
                ScanResult scanResult = RunTimeScan.dynamicPackageScan(drillConfig, Sets.newHashSet(urls));
                return scanResult;
            }
            finally {
                if (markerFileConnection instanceof JarURLConnection) {
                    ((JarURLConnection)markerFileConnection).getJarFile().close();
                }
            }
        }
        throw new JarValidationException(String.format("Marker file %s is missing in %s", "drill-module.conf", path.getName()));
    }

    private List<String> getMissingJars(RemoteFunctionRegistry remoteFunctionRegistry, LocalFunctionRegistry localFunctionRegistry, DataChangeVersion version) {
        List<UserBitShared.Jar> remoteJars = remoteFunctionRegistry.getRegistry(version).getJarList();
        List<String> localJars = localFunctionRegistry.getAllJarNames();
        ArrayList<String> missingJars = new ArrayList<String>();
        for (UserBitShared.Jar jar : remoteJars) {
            if (localJars.contains(jar.getName())) continue;
            missingJars.add(jar.getName());
        }
        return missingJars;
    }

    public Map<String, List<FunctionHolder>> getAllJarsWithFunctionsHolders() {
        if (this.useDynamicUdfs) {
            this.syncWithRemoteRegistry(this.localFunctionRegistry.getVersion());
        }
        return this.localFunctionRegistry.getAllJarsWithFunctionsHolders();
    }

    private Path getLocalUdfDir(DrillConfig config) {
        this.tmpDir = this.getTmpDir(config);
        File udfDir = new File(this.tmpDir, config.getString("drill.exec.udf.directory.local"));
        String udfPath = udfDir.getPath();
        if (udfDir.mkdirs()) {
            logger.debug("Local udf directory [{}] was created", (Object)udfPath);
        }
        Preconditions.checkState(udfDir.exists(), "Local udf directory [%s] must exist", (Object)udfPath);
        Preconditions.checkState(udfDir.isDirectory(), "Local udf directory [%s] must be a directory", (Object)udfPath);
        Preconditions.checkState(udfDir.canWrite(), "Local udf directory [%s] must be writable for application user", (Object)udfPath);
        try {
            FileUtils.cleanDirectory((File)udfDir);
        }
        catch (IOException e) {
            throw new DrillRuntimeException("Error during local udf directory clean up", e);
        }
        logger.info("Created and validated local udf directory [{}]", (Object)udfPath);
        return new Path(udfDir.toURI());
    }

    private File getTmpDir(DrillConfig config) {
        String drillTempDir = config.hasPath("drill.tmp-dir") ? config.getString("drill.tmp-dir") : System.getenv("DRILL_TMP_DIR");
        if (drillTempDir == null) {
            this.deleteTmpDir = true;
            return DrillFileUtils.createTempDir();
        }
        return new File(drillTempDir);
    }

    private Path copyJarToLocal(String jarName, RemoteFunctionRegistry remoteFunctionRegistry) throws IOException {
        Path registryArea = remoteFunctionRegistry.getRegistryArea();
        FileSystem fs = remoteFunctionRegistry.getFs();
        Path remoteJar = new Path(registryArea, jarName);
        Path localJar = new Path(this.localUdfDir, jarName);
        try {
            fs.copyToLocalFile(remoteJar, localJar);
        }
        catch (IOException e) {
            String message = String.format("Error during jar [%s] coping from [%s] to [%s]", jarName, registryArea.toUri().getPath(), this.localUdfDir.toUri().getPath());
            throw new IOException(message, e);
        }
        return localJar;
    }

    private void deleteQuietlyLocalJar(Path jar) {
        if (jar != null) {
            FileUtils.deleteQuietly((File)new File(jar.toUri().getPath()));
        }
    }

    @Override
    public void close() {
        this.localFunctionRegistry.close();
        if (this.deleteTmpDir) {
            FileUtils.deleteQuietly((File)this.tmpDir);
        } else {
            try {
                File localDir = new File(this.localUdfDir.toUri().getPath());
                if (localDir.exists()) {
                    FileUtils.cleanDirectory((File)localDir);
                }
            }
            catch (IOException e) {
                logger.warn("Problems during local udf directory clean up", (Throwable)e);
            }
        }
    }

    private class UnregistrationListener
    implements TransientStoreListener {
        private UnregistrationListener() {
        }

        @Override
        public void onChange(TransientStoreEvent<?> event) {
            String jarName = (String)event.getValue();
            FunctionImplementationRegistry.this.localFunctionRegistry.unregister(jarName);
            String localDir = FunctionImplementationRegistry.this.localUdfDir.toUri().getPath();
            FileUtils.deleteQuietly((File)new File(localDir, jarName));
            FileUtils.deleteQuietly((File)new File(localDir, JarUtil.getSourceName(jarName)));
        }
    }
}

