/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.fn.DrillAggFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionAttributes;
import org.apache.drill.exec.expr.fn.FunctionInitializer;
import org.apache.drill.exec.physical.impl.aggregate.HashAggBatch;
import org.apache.drill.exec.physical.impl.aggregate.HashAggTemplate;
import org.apache.drill.exec.physical.impl.aggregate.StreamingAggBatch;
import org.apache.drill.exec.physical.impl.aggregate.StreamingAggTemplate;
import org.apache.drill.exec.record.VectorAccessibleComplexWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class DrillComplexWriterAggFuncHolder
extends DrillAggFuncHolder {
    private JVar complexWriter;
    private JVar writerIdx;
    private JVar lastWriterIdx;

    public DrillComplexWriterAggFuncHolder(FunctionAttributes functionAttributes, FunctionInitializer initializer) {
        super(functionAttributes, initializer);
    }

    @Override
    public boolean isComplexWriterFuncHolder() {
        return true;
    }

    @Override
    public JVar[] renderStart(ClassGenerator<?> classGenerator, ClassGenerator.HoldingContainer[] inputVariables, FieldReference fieldReference) {
        JInvocation container = classGenerator.getMappingSet().getOutgoing().invoke("getOutgoingContainer");
        this.complexWriter = classGenerator.declareClassField("complexWriter", classGenerator.getModel()._ref(BaseWriter.ComplexWriter.class));
        if (classGenerator.getMappingSet().isHashAggMapping()) {
            String refName = fieldReference == null ? "col" : fieldReference.getRootSegment().getPath();
            JClass cwClass = classGenerator.getModel().ref(VectorAccessibleComplexWriter.class);
            classGenerator.getSetupBlock().assign((JAssignmentTarget)this.complexWriter, (JExpression)cwClass.staticInvoke("getWriter").arg(refName).arg((JExpression)container));
            return super.renderStart(classGenerator, inputVariables, fieldReference);
        }
        this.writerIdx = classGenerator.declareClassField("writerIdx", classGenerator.getModel()._ref(Integer.TYPE));
        this.lastWriterIdx = classGenerator.declareClassField("lastWriterIdx", classGenerator.getModel()._ref(Integer.TYPE));
        String refName = fieldReference == null ? "col" : fieldReference.getRootSegment().getPath();
        JClass cwClass = classGenerator.getModel().ref(VectorAccessibleComplexWriter.class);
        classGenerator.getSetupBlock().assign((JAssignmentTarget)this.complexWriter, (JExpression)cwClass.staticInvoke("getWriter").arg(refName).arg((JExpression)container));
        classGenerator.getSetupBlock().assign((JAssignmentTarget)this.writerIdx, JExpr.lit((int)0));
        classGenerator.getSetupBlock().assign((JAssignmentTarget)this.lastWriterIdx, JExpr.lit((int)-1));
        JVar[] workspaceJVars = this.declareWorkspaceVariables(classGenerator);
        this.generateBody(classGenerator, ClassGenerator.BlockType.SETUP, this.setup(), null, workspaceJVars, true);
        return workspaceJVars;
    }

    @Override
    public void renderMiddle(ClassGenerator<?> classGenerator, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars) {
        classGenerator.getEvalBlock().directStatement(String.format("//---- start of eval portion of %s function. ----//", this.getRegisteredNames()[0]));
        JBlock sub = new JBlock(true, true);
        JClass aggBatchClass = null;
        if (classGenerator.getCodeGenerator().getDefinition() == StreamingAggTemplate.TEMPLATE_DEFINITION) {
            aggBatchClass = classGenerator.getModel().ref(StreamingAggBatch.class);
        } else if (classGenerator.getCodeGenerator().getDefinition() == HashAggTemplate.TEMPLATE_DEFINITION) {
            aggBatchClass = classGenerator.getModel().ref(HashAggBatch.class);
        }
        JCast aggBatch = JExpr.cast((JType)aggBatchClass, (JExpression)classGenerator.getMappingSet().getOutgoing());
        classGenerator.getSetupBlock().add((JStatement)aggBatch.invoke("addComplexWriter").arg((JExpression)this.complexWriter));
        if (classGenerator.getMappingSet().isHashAggMapping()) {
            classGenerator.getEvalBlock().add((JStatement)this.complexWriter.invoke("setPosition").arg((JExpression)classGenerator.getMappingSet().getWorkspaceIndex()));
        } else {
            JBlock condAssignCW = classGenerator.getEvalBlock()._if(this.lastWriterIdx.ne((JExpression)this.writerIdx))._then();
            condAssignCW.add((JStatement)this.complexWriter.invoke("setPosition").arg((JExpression)this.writerIdx));
            condAssignCW.assign((JAssignmentTarget)this.lastWriterIdx, (JExpression)this.writerIdx);
        }
        sub.decl(classGenerator.getModel()._ref(BaseWriter.ComplexWriter.class), this.getReturnValue().getName(), (JExpression)this.complexWriter);
        classGenerator.getEvalBlock().add((JStatement)sub);
        this.addProtectedBlock(classGenerator, sub, this.add(), inputVariables, workspaceJVars, false);
        classGenerator.getEvalBlock().directStatement(String.format("//---- end of eval portion of %s function. ----//", this.getRegisteredNames()[0]));
    }

    @Override
    public ClassGenerator.HoldingContainer renderEnd(ClassGenerator<?> classGenerator, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars, FunctionHolderExpression holderExpr) {
        ClassGenerator.HoldingContainer out = null;
        JVar internalOutput = null;
        if (this.getReturnType().getMinorType() != TypeProtos.MinorType.LATE) {
            out = classGenerator.declare(this.getReturnType(), false);
        }
        JBlock sub = new JBlock();
        if (this.getReturnType().getMinorType() != TypeProtos.MinorType.LATE) {
            internalOutput = sub.decl(8, classGenerator.getHolderType(this.getReturnType()), this.getReturnValue().getName(), (JExpression)JExpr._new((JType)classGenerator.getHolderType(this.getReturnType())));
        }
        classGenerator.getEvalBlock().add((JStatement)sub);
        if (this.getReturnType().getMinorType() == TypeProtos.MinorType.LATE && !classGenerator.getMappingSet().isHashAggMapping()) {
            sub.assignPlus((JAssignmentTarget)this.writerIdx, JExpr.lit((int)1));
        }
        this.addProtectedBlock(classGenerator, sub, this.output(), null, workspaceJVars, false);
        if (this.getReturnType().getMinorType() != TypeProtos.MinorType.LATE) {
            sub.assign((JAssignmentTarget)out.getHolder(), (JExpression)internalOutput);
        }
        if (!classGenerator.getMappingSet().isHashAggMapping()) {
            this.generateBody(classGenerator, ClassGenerator.BlockType.RESET, this.reset(), null, workspaceJVars, false);
        }
        this.generateBody(classGenerator, ClassGenerator.BlockType.CLEANUP, this.cleanup(), null, workspaceJVars, false);
        return out;
    }
}

