/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.DirectExpression;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionAttributes;
import org.apache.drill.exec.expr.fn.FunctionInitializer;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;

class DrillAggFuncHolder
extends DrillFuncHolder {
    protected String setup() {
        return this.meth("setup");
    }

    protected String reset() {
        return this.meth("reset", false);
    }

    protected String add() {
        return this.meth("add");
    }

    protected String output() {
        return this.meth("output");
    }

    protected String cleanup() {
        return this.meth("cleanup", false);
    }

    public DrillAggFuncHolder(FunctionAttributes attributes, FunctionInitializer initializer) {
        super(attributes, initializer);
    }

    @Override
    public boolean isNested() {
        return true;
    }

    @Override
    public boolean isAggregating() {
        return true;
    }

    @Override
    public JVar[] renderStart(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables, FieldReference fieldReference) {
        if (!g.getMappingSet().isHashAggMapping()) {
            JVar[] workspaceJVars = this.declareWorkspaceVariables(g);
            this.generateBody(g, ClassGenerator.BlockType.SETUP, this.setup(), null, workspaceJVars, true);
            return workspaceJVars;
        }
        JVar[] workspaceJVars = this.declareWorkspaceVectors(g);
        JBlock setupBlock = g.getSetupBlock();
        JVar sizeVar = setupBlock.decl((JType)g.getModel().INT, "vectorSize", JExpr.lit((int)Integer.MAX_VALUE));
        JClass mathClass = g.getModel().ref(Math.class);
        for (int id = 0; id < this.getWorkspaceVars().length; ++id) {
            if (this.getWorkspaceVars()[id].isInject()) continue;
            setupBlock.assign((JAssignmentTarget)sizeVar, (JExpression)mathClass.staticInvoke("min").arg((JExpression)sizeVar).arg((JExpression)g.getWorkspaceVectors().get(this.getWorkspaceVars()[id]).invoke("getValueCapacity")));
        }
        for (int i = 0; i < this.getWorkspaceVars().length; ++i) {
            if (this.getWorkspaceVars()[i].isInject()) continue;
            setupBlock.assign((JAssignmentTarget)workspaceJVars[i], (JExpression)JExpr._new((JType)g.getHolderType(this.getWorkspaceVars()[i].getMajorType())));
        }
        JForLoop forLoop = setupBlock._for();
        JVar ivar = forLoop.init((JType)g.getModel().INT, "drill_internal_i", JExpr.lit((int)0));
        forLoop.test(ivar.lt((JExpression)sizeVar));
        forLoop.update(ivar.assignPlus(JExpr.lit((int)1)));
        JBlock subBlock = this.generateInitWorkspaceBlockHA(g, ClassGenerator.BlockType.SETUP, this.setup(), workspaceJVars, (JExpression)ivar);
        forLoop.body().add((JStatement)subBlock);
        return workspaceJVars;
    }

    @Override
    public void renderMiddle(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars) {
        this.addProtectedBlock(g, g.getBlock(ClassGenerator.BlockType.EVAL), this.add(), inputVariables, workspaceJVars, false);
    }

    @Override
    public ClassGenerator.HoldingContainer renderEnd(ClassGenerator<?> classGenerator, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars, FunctionHolderExpression holderExpr) {
        ClassGenerator.HoldingContainer out = null;
        JVar internalOutput = null;
        if (this.getReturnType().getMinorType() != TypeProtos.MinorType.LATE) {
            out = classGenerator.declare(this.getReturnType(), false);
        }
        JBlock sub = new JBlock();
        if (this.getReturnType().getMinorType() != TypeProtos.MinorType.LATE) {
            internalOutput = sub.decl(8, classGenerator.getHolderType(this.getReturnType()), this.getReturnValue().getName(), (JExpression)JExpr._new((JType)classGenerator.getHolderType(this.getReturnType())));
        }
        classGenerator.getEvalBlock().add((JStatement)sub);
        this.addProtectedBlock(classGenerator, sub, this.output(), null, workspaceJVars, false);
        if (this.getReturnType().getMinorType() != TypeProtos.MinorType.LATE) {
            sub.assign((JAssignmentTarget)out.getHolder(), (JExpression)internalOutput);
        }
        if (!classGenerator.getMappingSet().isHashAggMapping()) {
            this.generateBody(classGenerator, ClassGenerator.BlockType.RESET, this.reset(), null, workspaceJVars, false);
        }
        this.generateBody(classGenerator, ClassGenerator.BlockType.CLEANUP, this.cleanup(), null, workspaceJVars, false);
        return out;
    }

    private JVar[] declareWorkspaceVectors(ClassGenerator<?> g) {
        JVar[] workspaceJVars = new JVar[this.getWorkspaceVars().length];
        for (int i = 0; i < this.getWorkspaceVars().length; ++i) {
            if (this.getWorkspaceVars()[i].isInject()) {
                workspaceJVars[i] = g.declareClassField("work", g.getModel()._ref(this.getWorkspaceVars()[i].getType()));
                this.assignInjectableValue(g, workspaceJVars[i], this.getWorkspaceVars()[i]);
                continue;
            }
            Preconditions.checkState(Types.isFixedWidthType(this.getWorkspaceVars()[i].getMajorType()), String.format("Workspace variable '%s' in aggregation function '%s' is not allowed to have variable length type.", this.getWorkspaceVars()[i].getName(), this.getRegisteredNames()[0]));
            Preconditions.checkState(this.getWorkspaceVars()[i].getMajorType().getMode() == TypeProtos.DataMode.REQUIRED, String.format("Workspace variable '%s' in aggregation function '%s' is not allowed to have null or repeated type.", this.getWorkspaceVars()[i].getName(), this.getRegisteredNames()[0]));
            workspaceJVars[i] = g.declareClassField("work", g.getHolderType(this.getWorkspaceVars()[i].getMajorType()));
            TypedFieldId typedFieldId = new TypedFieldId.Builder().finalType(this.getWorkspaceVars()[i].getMajorType()).addId(g.getWorkspaceTypes().size()).build();
            JVar vv = g.declareVectorValueSetupAndMember(g.getMappingSet().getWorkspace(), typedFieldId);
            g.getWorkspaceTypes().add(typedFieldId);
            g.getWorkspaceVectors().put(this.getWorkspaceVars()[i], vv);
        }
        return workspaceJVars;
    }

    private JBlock generateInitWorkspaceBlockHA(ClassGenerator<?> g, ClassGenerator.BlockType bt, String body, JVar[] workspaceJVars, JExpression wsIndexVariable) {
        JBlock initBlock = new JBlock(true, true);
        if (!Strings.isNullOrEmpty(body) && !body.trim().isEmpty()) {
            JBlock sub = new JBlock(true, true);
            this.addProtectedBlockHA(g, sub, body, null, workspaceJVars, wsIndexVariable);
            initBlock.directStatement(String.format("/** start %s for function %s **/ ", bt.name(), this.getRegisteredNames()[0]));
            initBlock.add((JStatement)sub);
            initBlock.directStatement(String.format("/** end %s for function %s **/ ", bt.name(), this.getRegisteredNames()[0]));
        }
        return initBlock;
    }

    @Override
    protected void addProtectedBlock(ClassGenerator<?> g, JBlock sub, String body, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars, boolean decConstantInputOnly) {
        if (!g.getMappingSet().isHashAggMapping()) {
            super.addProtectedBlock(g, sub, body, inputVariables, workspaceJVars, decConstantInputOnly);
        } else {
            DirectExpression indexVariable = g.getMappingSet().getWorkspaceIndex();
            this.addProtectedBlockHA(g, sub, body, inputVariables, workspaceJVars, (JExpression)indexVariable);
        }
    }

    private void addProtectedBlockHA(ClassGenerator<?> g, JBlock sub, String body, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars, JExpression wsIndexVariable) {
        int i;
        if (inputVariables != null) {
            if (this.isVarArg()) {
                this.declareVarArgArray(g.getModel(), sub, inputVariables);
            }
            for (int i2 = 0; i2 < inputVariables.length; ++i2) {
                this.declareInputVariable(g.getModel(), sub, inputVariables[i2], i2);
            }
        }
        JVar[] internalVars = new JVar[workspaceJVars.length];
        for (i = 0; i < workspaceJVars.length; ++i) {
            if (this.getWorkspaceVars()[i].isInject()) {
                internalVars[i] = sub.decl(g.getModel()._ref(this.getWorkspaceVars()[i].getType()), this.getWorkspaceVars()[i].getName(), (JExpression)workspaceJVars[i]);
                continue;
            }
            JInvocation getValueAccessor = g.getWorkspaceVectors().get(this.getWorkspaceVars()[i]).invoke("getAccessor").invoke("get");
            if (Types.usesHolderForGet(this.getWorkspaceVars()[i].getMajorType())) {
                sub.add((JStatement)getValueAccessor.arg(wsIndexVariable).arg((JExpression)workspaceJVars[i]));
            } else {
                sub.assign((JAssignmentTarget)workspaceJVars[i].ref("value"), (JExpression)getValueAccessor.arg(wsIndexVariable));
            }
            internalVars[i] = sub.decl(g.getHolderType(this.getWorkspaceVars()[i].getMajorType()), this.getWorkspaceVars()[i].getName(), (JExpression)workspaceJVars[i]);
        }
        Preconditions.checkNotNull(body);
        sub.directStatement(body);
        for (i = 0; i < workspaceJVars.length; ++i) {
            sub.assign((JAssignmentTarget)workspaceJVars[i], (JExpression)internalVars[i]);
            if (this.getWorkspaceVars()[i].isInject()) continue;
            TypeProtos.MajorType type = this.getWorkspaceVars()[i].getMajorType();
            JInvocation setMeth = Types.usesHolderForGet(type) ? g.getWorkspaceVectors().get(this.getWorkspaceVars()[i]).invoke("getMutator").invoke("setSafe").arg(wsIndexVariable).arg((JExpression)workspaceJVars[i]) : (!Types.isFixedWidthType(type) || Types.isRepeated(type) ? g.getWorkspaceVectors().get(this.getWorkspaceVars()[i]).invoke("getMutator").invoke("setSafe").arg(wsIndexVariable).arg((JExpression)workspaceJVars[i].ref("value")) : g.getWorkspaceVectors().get(this.getWorkspaceVars()[i]).invoke("getMutator").invoke("set").arg(wsIndexVariable).arg((JExpression)workspaceJVars[i].ref("value")));
            sub.add((JStatement)setMeth);
        }
    }

    @Override
    protected void checkNullHandling(FunctionTemplate.NullHandling nullHandling) {
        Preconditions.checkArgument(nullHandling == FunctionTemplate.NullHandling.INTERNAL, "An aggregate function is required to handle null input(s) on its own.");
    }
}

