/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.fn.FunctionAttributes;
import org.apache.drill.exec.expr.fn.output.ConcatReturnTypeInference;
import org.apache.drill.exec.expr.fn.output.DecimalReturnTypeInference;
import org.apache.drill.exec.expr.fn.output.DefaultReturnTypeInference;
import org.apache.drill.exec.expr.fn.output.OutputWidthCalculator;
import org.apache.drill.exec.expr.fn.output.OutputWidthCalculators;
import org.apache.drill.exec.expr.fn.output.PadReturnTypeInference;
import org.apache.drill.exec.expr.fn.output.ReturnTypeInference;
import org.apache.drill.exec.expr.fn.output.SameInOutLengthReturnTypeInference;
import org.apache.drill.exec.expr.fn.output.StringCastReturnTypeInference;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface FunctionTemplate {
    public static final int OUTPUT_SIZE_ESTIMATE_DEFAULT = -1;

    public String name() default "";

    public String[] names() default {};

    public FunctionScope scope();

    public ReturnType returnType() default ReturnType.DEFAULT;

    public NullHandling nulls() default NullHandling.INTERNAL;

    public boolean isBinaryCommutative() default false;

    public boolean isRandom() default false;

    public String desc() default "";

    public FunctionCostCategory costCategory() default FunctionCostCategory.SIMPLE;

    public boolean isNiladic() default false;

    public boolean checkPrecisionRange() default false;

    public boolean isInternal() default false;

    public boolean isVarArg() default false;

    public OutputWidthCalculatorType outputWidthCalculatorType() default OutputWidthCalculatorType.DEFAULT;

    public int outputSizeEstimate() default -1;

    public static enum FunctionCostCategory {
        SIMPLE(1),
        MEDIUM(20),
        COMPLEX(50);

        private final int value;

        private FunctionCostCategory(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static FunctionCostCategory getDefault() {
            return SIMPLE;
        }
    }

    public static enum ReturnType {
        DEFAULT(DefaultReturnTypeInference.INSTANCE),
        STRING_CAST(StringCastReturnTypeInference.INSTANCE),
        CONCAT(ConcatReturnTypeInference.INSTANCE),
        PAD(PadReturnTypeInference.INSTANCE),
        SAME_IN_OUT_LENGTH(SameInOutLengthReturnTypeInference.INSTANCE),
        DECIMAL_AGGREGATE(DecimalReturnTypeInference.DecimalAggReturnTypeInference.INSTANCE),
        DECIMAL_SUM_AGGREGATE(DecimalReturnTypeInference.DecimalSumAggReturnTypeInference.INSTANCE),
        DECIMAL_AVG_AGGREGATE(DecimalReturnTypeInference.DecimalAvgAggReturnTypeInference.INSTANCE),
        DECIMAL_MAX_SCALE(DecimalReturnTypeInference.DecimalMaxScaleReturnTypeInference.INSTANCE),
        DECIMAL_SUM_SCALE(DecimalReturnTypeInference.DecimalSumScaleReturnTypeInference.INSTANCE),
        DECIMAL_CAST(DecimalReturnTypeInference.DecimalCastReturnTypeInference.INSTANCE),
        DECIMAL_DIV_SCALE(DecimalReturnTypeInference.DecimalDivScaleReturnTypeInference.INSTANCE),
        DECIMAL_MOD_SCALE(DecimalReturnTypeInference.DecimalModScaleReturnTypeInference.INSTANCE),
        DECIMAL_ADD_SCALE(DecimalReturnTypeInference.DecimalAddReturnTypeInference.INSTANCE),
        DECIMAL_SET_SCALE(DecimalReturnTypeInference.DecimalSetScaleReturnTypeInference.INSTANCE),
        DECIMAL_ZERO_SCALE(DecimalReturnTypeInference.DecimalZeroScaleReturnTypeInference.INSTANCE);

        private final ReturnTypeInference inference;

        private ReturnType(ReturnTypeInference inference) {
            this.inference = inference;
        }

        public TypeProtos.MajorType getType(List<LogicalExpression> logicalExpressions, FunctionAttributes attributes) {
            return this.inference.getType(logicalExpressions, attributes);
        }
    }

    public static enum FunctionScope {
        SIMPLE,
        POINT_AGGREGATE,
        HOLISTIC_AGGREGATE,
        RANGE_AGGREGATE;

    }

    public static enum NullHandling {
        INTERNAL,
        NULL_IF_NULL;

    }

    public static enum OutputWidthCalculatorType {
        DEFAULT(OutputWidthCalculators.DefaultOutputWidthCalculator.INSTANCE),
        CLONE(OutputWidthCalculators.CloneOutputWidthCalculator.INSTANCE),
        CONCAT(OutputWidthCalculators.ConcatOutputWidthCalculator.INSTANCE),
        CUSTOM_FIXED_WIDTH_DEFAULT(OutputWidthCalculators.DefaultOutputWidthCalculator.INSTANCE),
        CUSTOM_CLONE_DEFAULT(OutputWidthCalculators.CloneOutputWidthCalculator.INSTANCE);

        OutputWidthCalculator outputWidthCalculator;

        private OutputWidthCalculatorType(OutputWidthCalculator outputWidthCalculator) {
            this.outputWidthCalculator = outputWidthCalculator;
        }

        public OutputWidthCalculator getOutputWidthCalculator() {
            return this.outputWidthCalculator;
        }
    }
}

