/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.io.IOException;
import org.apache.drill.exec.compile.TemplateClassDefinition;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.EvaluationVisitor;
import org.apache.drill.exec.expr.SingleClassStringWriter;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class CodeGenerator<T> {
    private static final String PACKAGE_NAME = "org.apache.drill.exec.test.generated";
    private final TemplateClassDefinition<T> definition;
    private final String className;
    private final String fqcn;
    private final JCodeModel model;
    private final ClassGenerator<T> rootGenerator;
    private boolean plainJavaCapable;
    private boolean usePlainJava;
    private boolean saveDebugCode;
    private String generatedCode;
    private String generifiedCode;

    CodeGenerator(TemplateClassDefinition<T> definition, OptionSet optionManager) {
        this(ClassGenerator.getDefaultMapping(), definition, optionManager);
    }

    CodeGenerator(MappingSet mappingSet, TemplateClassDefinition<T> definition, OptionSet optionManager) {
        Preconditions.checkNotNull(definition.getSignature(), "The signature for defintion %s was incorrectly initialized.", definition);
        this.definition = definition;
        this.className = definition.getExternalInterface().getSimpleName() + "Gen" + definition.getNextClassNumber();
        this.fqcn = "org.apache.drill.exec.test.generated." + this.className;
        try {
            this.model = new JCodeModel();
            JDefinedClass clazz = this.model._package(PACKAGE_NAME)._class(this.className);
            this.rootGenerator = new ClassGenerator(this, mappingSet, definition.getSignature(), new EvaluationVisitor(), clazz, this.model, optionManager);
        }
        catch (JClassAlreadyExistsException e) {
            throw new IllegalStateException(e);
        }
    }

    public void plainJavaCapable(boolean flag) {
        this.plainJavaCapable = flag;
    }

    public void preferPlainJava(boolean flag) {
        this.usePlainJava = flag;
    }

    public boolean supportsPlainJava() {
        return this.plainJavaCapable;
    }

    public boolean isPlainJava() {
        return this.plainJavaCapable && this.usePlainJava;
    }

    public void saveCodeForDebugging(boolean persist) {
        if (this.supportsPlainJava()) {
            this.saveDebugCode = persist;
            this.usePlainJava = true;
        }
    }

    public boolean isCodeToBeSaved() {
        return this.saveDebugCode;
    }

    public ClassGenerator<T> getRoot() {
        return this.rootGenerator;
    }

    public void generate() {
        if (this.isPlainJava()) {
            this.rootGenerator.preparePlainJava();
        }
        this.rootGenerator.flushCode();
        SingleClassStringWriter w = new SingleClassStringWriter();
        try {
            this.model.build((CodeWriter)w);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.generatedCode = w.getCode().toString();
        this.generifiedCode = this.generatedCode.replaceAll(this.className, "GenericGenerated");
    }

    public String generateAndGet() throws IOException {
        this.generate();
        return this.generatedCode;
    }

    public String getGeneratedCode() {
        return this.generatedCode;
    }

    public TemplateClassDefinition<T> getDefinition() {
        return this.definition;
    }

    public String getMaterializedClassName() {
        return this.fqcn;
    }

    public String getClassName() {
        return this.className;
    }

    public static <T> CodeGenerator<T> get(TemplateClassDefinition<T> definition) {
        return CodeGenerator.get(definition, null);
    }

    public static <T> CodeGenerator<T> get(TemplateClassDefinition<T> definition, OptionSet optionManager) {
        return new CodeGenerator<T>(definition, optionManager);
    }

    public static <T> ClassGenerator<T> getRoot(TemplateClassDefinition<T> definition, OptionSet optionManager) {
        return CodeGenerator.get(definition, optionManager).getRoot();
    }

    public static <T> ClassGenerator<T> getRoot(MappingSet mappingSet, TemplateClassDefinition<T> definition, OptionSet optionManager) {
        return CodeGenerator.get(mappingSet, definition, optionManager).getRoot();
    }

    public static <T> CodeGenerator<T> get(MappingSet mappingSet, TemplateClassDefinition<T> definition, OptionSet optionManager) {
        return new CodeGenerator<T>(mappingSet, definition, optionManager);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.generifiedCode == null ? 0 : this.generifiedCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeGenerator other = (CodeGenerator)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        return !(this.generifiedCode == null ? other.generifiedCode != null : !this.generifiedCode.equals(other.generifiedCode));
    }
}

