/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.dotdrill;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.drill.exec.dotdrill.DotDrillType;
import org.apache.drill.exec.dotdrill.View;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;

public class DotDrillFile {
    private final FileStatus status;
    private final DotDrillType type;
    private final DrillFileSystem fs;

    public static DotDrillFile create(DrillFileSystem fs, FileStatus status) {
        for (DotDrillType d : DotDrillType.values()) {
            if (status.isDirectory() || !d.matches(status)) continue;
            return new DotDrillFile(fs, status, d);
        }
        return null;
    }

    private DotDrillFile(DrillFileSystem fs, FileStatus status, DotDrillType type) {
        this.fs = fs;
        this.status = status;
        this.type = type;
    }

    public DotDrillType getType() {
        return this.type;
    }

    public String getOwner() {
        if (this.type == DotDrillType.VIEW && this.status.getOwner().isEmpty()) {
            return ImpersonationUtil.getProcessUserName();
        }
        return this.status.getOwner();
    }

    public String getBaseName() {
        String fileName = this.status.getPath().getName();
        return fileName.substring(0, fileName.lastIndexOf(this.type.getEnding()));
    }

    public View getView(ObjectMapper mapper) throws IOException {
        Preconditions.checkArgument(this.type == DotDrillType.VIEW);
        try (FSDataInputStream is = this.fs.open(this.status.getPath());){
            View view = (View)mapper.readValue((InputStream)is, View.class);
            return view;
        }
    }
}

