/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.coord.zk;

import org.apache.curator.framework.CuratorFramework;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.coord.store.TransientStoreConfig;
import org.apache.drill.exec.coord.store.TransientStoreFactory;
import org.apache.drill.exec.coord.zk.ZkEphemeralStore;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class ZkTransientStoreFactory
implements TransientStoreFactory {
    private final CuratorFramework curator;

    public ZkTransientStoreFactory(CuratorFramework curator) {
        this.curator = Preconditions.checkNotNull(curator, "curator is required");
    }

    public <V> ZkEphemeralStore<V> getOrCreateStore(TransientStoreConfig<V> config) {
        ZkEphemeralStore<V> store = new ZkEphemeralStore<V>(config, this.curator);
        try {
            store.start();
        }
        catch (Exception e) {
            throw new DrillRuntimeException("unable to start zookeeper transient store", e);
        }
        return store;
    }

    @Override
    public void close() throws Exception {
    }
}

