/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.coord.store;

import java.util.ArrayList;
import java.util.Map;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.coord.store.TransientStore;
import org.apache.drill.exec.coord.store.TransientStoreConfig;
import org.apache.drill.exec.coord.store.TransientStoreFactory;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class CachingTransientStoreFactory
implements TransientStoreFactory {
    private final TransientStoreFactory delegate;
    private final Map<TransientStoreConfig, TransientStore> cache = Maps.newHashMap();

    public CachingTransientStoreFactory(TransientStoreFactory delegate) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate factory is required");
    }

    @Override
    public <V> TransientStore<V> getOrCreateStore(TransientStoreConfig<V> config) {
        TransientStore store = this.cache.get(Preconditions.checkNotNull(config, "config is required"));
        if (store != null) {
            return store;
        }
        TransientStore<V> newStore = this.delegate.getOrCreateStore(config);
        this.cache.put(config, newStore);
        return newStore;
    }

    @Override
    public void close() throws Exception {
        ArrayList<AutoCloseable> closeables = Lists.newArrayList();
        for (AutoCloseable autoCloseable : this.cache.values()) {
            closeables.add(autoCloseable);
        }
        closeables.add(this.delegate);
        this.cache.clear();
        AutoCloseables.close(closeables);
    }

    public static TransientStoreFactory of(TransientStoreFactory delegate) {
        return new CachingTransientStoreFactory(delegate);
    }
}

