/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.sig;

import java.util.Arrays;
import org.apache.drill.exec.compile.sig.GeneratorMapping;
import org.apache.drill.exec.expr.DirectExpression;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingSet {
    static final Logger logger = LoggerFactory.getLogger(MappingSet.class);
    private GeneratorMapping constant;
    private GeneratorMapping[] mappings;
    private int mappingIndex;
    private GeneratorMapping current;
    private DirectExpression readIndex;
    private DirectExpression writeIndex;
    private DirectExpression incoming;
    private DirectExpression outgoing;
    private DirectExpression workspace;
    private DirectExpression workspaceIndex;

    public MappingSet(GeneratorMapping mapping) {
        this("inIndex", "outIndex", mapping, mapping);
    }

    public boolean hasEmbeddedConstant() {
        return this.constant == this.current;
    }

    public MappingSet(String readIndex, String writeIndex, String workspaceIndex, String incoming, String outgoing, String workspace, GeneratorMapping ... mappings) {
        this(readIndex, writeIndex, incoming, outgoing, mappings);
        this.workspaceIndex = DirectExpression.direct(workspaceIndex);
        this.workspace = DirectExpression.direct(workspace);
    }

    public MappingSet(GeneratorMapping ... mappings) {
        this("inIndex", "outIndex", mappings);
    }

    public MappingSet(String readIndex, String writeIndex, GeneratorMapping ... mappings) {
        this(readIndex, writeIndex, "incoming", "outgoing", mappings);
    }

    public MappingSet(String readIndex, String writeIndex, String incoming, String outgoing, GeneratorMapping ... mappings) {
        this.readIndex = DirectExpression.direct(readIndex);
        this.writeIndex = DirectExpression.direct(writeIndex);
        this.incoming = DirectExpression.direct(incoming);
        this.outgoing = DirectExpression.direct(outgoing);
        Preconditions.checkArgument(mappings.length >= 2);
        this.constant = mappings[0];
        for (int i = 1; i < mappings.length; ++i) {
            if (mappings[0] != mappings[i]) continue;
            this.constant = new GeneratorMapping(mappings[0]);
            break;
        }
        this.mappings = Arrays.copyOfRange(mappings, 1, mappings.length);
        this.current = this.mappings[0];
    }

    public void enterConstant() {
        assert (this.constant != this.current);
        this.current = this.constant;
    }

    public void exitConstant() {
        assert (this.constant == this.current);
        this.current = this.mappings[this.mappingIndex];
    }

    public boolean isWithinConstant() {
        return this.constant == this.current;
    }

    public void enterChild() {
        assert (this.current == this.mappings[this.mappingIndex]);
        ++this.mappingIndex;
        if (this.mappingIndex >= this.mappings.length) {
            throw new IllegalStateException("This generator does not support mappings beyond");
        }
        this.current = this.mappings[this.mappingIndex];
    }

    public void exitChild() {
        assert (this.current == this.mappings[this.mappingIndex]);
        --this.mappingIndex;
        if (this.mappingIndex < 0) {
            throw new IllegalStateException("You tried to traverse higher than the provided mapping provides.");
        }
        this.current = this.mappings[this.mappingIndex];
    }

    public GeneratorMapping getCurrentMapping() {
        return this.current;
    }

    public DirectExpression getValueWriteIndex() {
        return this.writeIndex;
    }

    public DirectExpression getValueReadIndex() {
        return this.readIndex;
    }

    public DirectExpression getOutgoing() {
        return this.outgoing;
    }

    public DirectExpression getIncoming() {
        return this.incoming;
    }

    public DirectExpression getWorkspaceIndex() {
        return this.workspaceIndex;
    }

    public DirectExpression getWorkspace() {
        return this.workspace;
    }

    public boolean isHashAggMapping() {
        return this.workspace != null;
    }
}

