/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.bytecode;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.cursors.ObjectIntCursor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.drill.exec.compile.bytecode.DirectSorter;
import org.apache.drill.exec.compile.bytecode.InstructionModifier;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.objectweb.asm.Type;

class ValueHolderIden {
    private final ObjectIntHashMap<String> fieldMap;
    private final Type[] types;
    private final String[] names;
    private final int[] offsets;
    private final Type type;

    public ValueHolderIden(Class<?> c) {
        Field[] fields = c.getFields();
        ArrayList<Field> fldList = Lists.newArrayList();
        for (Field f : fields) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            fldList.add(f);
        }
        this.type = Type.getType(c);
        this.types = new Type[fldList.size()];
        this.names = new String[fldList.size()];
        this.offsets = new int[fldList.size()];
        this.fieldMap = new ObjectIntHashMap(fldList.size());
        int i = 0;
        int offset = 0;
        for (Field f : fldList) {
            this.types[i] = Type.getType(f.getType());
            this.names[i] = f.getName();
            this.offsets[i] = offset;
            this.fieldMap.put((Object)f.getName(), i);
            offset += this.types[i].getSize();
            ++i;
        }
    }

    public void dump(StringBuilder sb) {
        sb.append("ValueHolderIden: type=" + this.type + '\n');
        for (ObjectIntCursor oic : this.fieldMap) {
            sb.append("  " + (String)oic.key + ": i=" + oic.value + ", type=" + this.types[oic.value] + ", offset=" + this.offsets[oic.value] + '\n');
        }
    }

    private static void initType(int offset, Type t, DirectSorter v) {
        switch (t.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                v.visitInsn(3);
                v.directVarInsn(54, offset);
                break;
            }
            case 7: {
                v.visitInsn(9);
                v.directVarInsn(55, offset);
                break;
            }
            case 6: {
                v.visitInsn(11);
                v.directVarInsn(56, offset);
                break;
            }
            case 8: {
                v.visitInsn(14);
                v.directVarInsn(57, offset);
                break;
            }
            case 10: {
                v.visitInsn(1);
                v.directVarInsn(58, offset);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private int addLocals(DirectSorter adder, int defaultFirst) {
        int first = defaultFirst;
        for (int i = 0; i < this.types.length; ++i) {
            int varIndex = adder.newLocal(this.types[i]);
            if (i != 0) continue;
            first = varIndex;
        }
        return first;
    }

    public ValueHolderSub getHolderSub(DirectSorter adder) {
        int first = this.addLocals(adder, -1);
        return new ValueHolderSub(first);
    }

    public ValueHolderSub getHolderSubWithDefinedLocals(int first) {
        return new ValueHolderSub(first);
    }

    private static int getDupOpcode(Type type) {
        assert (type.getSize() >= 1);
        return type.getSize() == 1 ? 89 : 92;
    }

    public void transferToLocal(DirectSorter adder, int localVariable) {
        for (int i = 0; i < this.types.length; ++i) {
            Type t = this.types[i];
            if (i + 1 < this.types.length) {
                adder.visitInsn(89);
            }
            adder.visitFieldInsn(180, this.type.getInternalName(), this.names[i], t.getDescriptor());
            adder.directVarInsn(t.getOpcode(54), localVariable + this.offsets[i]);
        }
    }

    public int createLocalAndTransfer(DirectSorter adder) {
        int first = this.addLocals(adder, 0);
        this.transferToLocal(adder, first);
        return first;
    }

    public class ValueHolderSub {
        private int first;

        public String toString() {
            return "ValueHolderSub(" + this.first + ")";
        }

        public ValueHolderSub(int first) {
            assert (first != -1) : "Create Holder for sub that doesn't have any fields.";
            this.first = first;
        }

        public ValueHolderIden iden() {
            return ValueHolderIden.this;
        }

        public void init(DirectSorter mv) {
            for (int i = 0; i < ValueHolderIden.this.types.length; ++i) {
                ValueHolderIden.initType(this.first + ValueHolderIden.this.offsets[i], ValueHolderIden.this.types[i], mv);
            }
        }

        public int first() {
            return this.first;
        }

        private int getFieldIndex(String name, InstructionModifier mv) {
            if (!ValueHolderIden.this.fieldMap.containsKey((Object)name)) {
                throw new IllegalArgumentException(String.format("Unknown name '%s' on line %d.", name, mv.getLastLineNumber()));
            }
            return ValueHolderIden.this.fieldMap.get((Object)name);
        }

        public void addInsn(String name, InstructionModifier mv, int opcode) {
            switch (opcode) {
                case 180: {
                    this.addKnownInsn(name, mv, 21);
                    return;
                }
                case 181: {
                    this.addKnownInsn(name, mv, 54);
                }
            }
        }

        public void transfer(InstructionModifier mv, int newStart) {
            if (this.first == newStart) {
                return;
            }
            for (int i = 0; i < ValueHolderIden.this.types.length; ++i) {
                mv.directVarInsn(ValueHolderIden.this.types[i].getOpcode(21), this.first + ValueHolderIden.this.offsets[i]);
                mv.directVarInsn(ValueHolderIden.this.types[i].getOpcode(54), newStart + ValueHolderIden.this.offsets[i]);
            }
            this.first = newStart;
        }

        private void addKnownInsn(String name, InstructionModifier mv, int analogOpcode) {
            int f = this.getFieldIndex(name, mv);
            Type t = ValueHolderIden.this.types[f];
            mv.directVarInsn(t.getOpcode(analogOpcode), this.first + ValueHolderIden.this.offsets[f]);
        }

        public int transferToExternal(DirectSorter adder, String owner, String name, String desc) {
            adder.visitTypeInsn(187, ValueHolderIden.this.type.getInternalName());
            adder.visitInsn(ValueHolderIden.getDupOpcode(ValueHolderIden.this.type));
            adder.visitMethodInsn(183, ValueHolderIden.this.type.getInternalName(), "<init>", "()V", false);
            int additionalStack = 0;
            for (int i = 0; i < ValueHolderIden.this.types.length; ++i) {
                Type t = ValueHolderIden.this.types[i];
                adder.visitInsn(ValueHolderIden.getDupOpcode(ValueHolderIden.this.type));
                adder.directVarInsn(t.getOpcode(21), this.first + ValueHolderIden.this.offsets[i]);
                adder.visitFieldInsn(181, ValueHolderIden.this.type.getInternalName(), ValueHolderIden.this.names[i], t.getDescriptor());
                if (t.getSize() <= additionalStack) continue;
                additionalStack = t.getSize();
            }
            adder.visitFieldInsn(181, owner, name, desc);
            return additionalStack;
        }
    }
}

