/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.bytecode;

import java.util.LinkedList;
import org.apache.drill.exec.compile.CheckMethodVisitorFsm;
import org.apache.drill.exec.compile.bytecode.InstructionModifier;
import org.apache.drill.exec.compile.bytecode.MethodAnalyzer;
import org.apache.drill.exec.compile.bytecode.ReplacingBasicValue;
import org.apache.drill.exec.compile.bytecode.ReplacingInterpreter;
import org.apache.drill.exec.compile.bytecode.TrackingInstructionList;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalarReplacementNode
extends MethodNode {
    private static final Logger logger = LoggerFactory.getLogger(ScalarReplacementNode.class);
    private final boolean verifyBytecode;
    private final String className;
    private final String[] exceptionsArr;
    private final MethodVisitor inner;

    public ScalarReplacementNode(String className, int access, String name, String desc, String signature, String[] exceptions, MethodVisitor inner, boolean verifyBytecode) {
        super(589824, access, name, desc, signature, exceptions);
        this.className = className;
        this.exceptionsArr = exceptions;
        this.inner = inner;
        this.verifyBytecode = verifyBytecode;
    }

    public void visitEnd() {
        Frame<V>[] frames;
        super.visitEnd();
        LinkedList<ReplacingBasicValue> valueList = new LinkedList<ReplacingBasicValue>();
        MethodAnalyzer analyzer = new MethodAnalyzer(new ReplacingInterpreter(this.className, valueList));
        try {
            frames = analyzer.analyze(this.className, this);
        }
        catch (AnalyzerException e) {
            throw new IllegalStateException(e);
        }
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("ReplacingBasicValues for " + this.className + "\n");
            for (ReplacingBasicValue value : valueList) {
                value.dump(sb, 2);
                sb.append('\n');
            }
            logger.debug(sb.toString());
        }
        TrackingInstructionList list = new TrackingInstructionList(frames, this.instructions);
        this.instructions = list;
        MethodVisitor methodVisitor = this.inner;
        if (this.verifyBytecode) {
            methodVisitor = new CheckMethodVisitorFsm(589824, methodVisitor);
        }
        InstructionModifier holderV = new InstructionModifier(this.access, this.name, this.desc, this.signature, this.exceptionsArr, list, methodVisitor);
        this.accept(holderV);
    }
}

