/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.bytecode;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import org.apache.drill.exec.compile.bytecode.ReplacingBasicValue;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class MethodAnalyzer<V extends Value>
extends Analyzer<V> {
    private InsnList insnList;

    public MethodAnalyzer(Interpreter<V> interpreter) {
        super(interpreter);
    }

    protected Frame<V> newFrame(int maxLocals, int maxStack) {
        return new AssignmentTrackingFrame(maxLocals, maxStack);
    }

    protected Frame<V> newFrame(Frame<? extends V> src) {
        return new AssignmentTrackingFrame<V>(src);
    }

    protected void newControlFlowEdge(int insnIndex, int successorIndex) {
        AssignmentTrackingFrame oldFrame = (AssignmentTrackingFrame)this.getFrames()[insnIndex];
        AbstractInsnNode insn = this.insnList.get(insnIndex);
        if (insn.getType() == 8 && insn.equals(oldFrame.labelsStack.peekFirst())) {
            oldFrame.localVariablesSet.pop();
            oldFrame.labelsStack.pop();
        }
    }

    public Frame<V>[] analyze(String owner, MethodNode method) throws AnalyzerException {
        this.insnList = method.instructions;
        return super.analyze(owner, method);
    }

    private static class AssignmentTrackingFrame<V extends Value>
    extends Frame<V> {
        private Deque<BitSet> localVariablesSet = new ArrayDeque<BitSet>();
        private Deque<LabelNode> labelsStack;

        public AssignmentTrackingFrame(int nLocals, int nStack) {
            super(nLocals, nStack);
            this.localVariablesSet.push(new BitSet());
            this.labelsStack = new ArrayDeque<LabelNode>();
        }

        public AssignmentTrackingFrame(Frame<? extends V> src) {
            super(src);
            this.localVariablesSet.push(new BitSet());
            this.labelsStack = new ArrayDeque<LabelNode>();
        }

        public void setLocal(int i, V value) {
            if (value instanceof ReplacingBasicValue) {
                ReplacingBasicValue replacingValue = (ReplacingBasicValue)((Object)value);
                replacingValue.setFrameSlot(i);
                Value localValue = this.getLocal(i);
                BitSet currentLocalVars = this.localVariablesSet.element();
                if (localValue instanceof ReplacingBasicValue) {
                    if (!currentLocalVars.get(i)) {
                        replacingValue.setAssignedInConditionalBlock();
                    }
                    ReplacingBasicValue localReplacingValue = (ReplacingBasicValue)localValue;
                    localReplacingValue.associate(replacingValue);
                } else {
                    currentLocalVars.set(i);
                }
            }
            super.setLocal(i, value);
        }

        public void initJumpTarget(int opcode, LabelNode target) {
            if (target != null) {
                switch (opcode) {
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 198: 
                    case 199: {
                        this.localVariablesSet.push(new BitSet());
                        this.labelsStack.push(target);
                    }
                }
            }
        }

        public void clearStack() {
            super.clearStack();
            this.localVariablesSet = null;
            this.labelsStack = null;
        }
    }
}

