/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.drill.exec.compile.AbstractClassCompiler;
import org.apache.drill.exec.compile.ClassTransformer;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.ClassFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JaninoClassCompiler
extends AbstractClassCompiler {
    static final Logger logger = LoggerFactory.getLogger(JaninoClassCompiler.class);
    private final IClassLoader compilationClassLoader;

    public JaninoClassCompiler(ClassLoader parentClassLoader, boolean debug) {
        super(debug);
        this.compilationClassLoader = new ClassLoaderIClassLoader(parentClassLoader);
    }

    @Override
    protected byte[][] getByteCode(ClassTransformer.ClassNames className, String sourceCode) throws CompileException, IOException {
        List<ClassFile> classFiles = this.doCompile(sourceCode);
        byte[][] byteCodes = new byte[classFiles.size()][];
        for (int i = 0; i < classFiles.size(); ++i) {
            byteCodes[i] = classFiles.get(i).toByteArray();
        }
        return byteCodes;
    }

    @Override
    public Map<String, byte[]> compile(ClassTransformer.ClassNames className, String sourceCode) throws CompileException, IOException, ClassNotFoundException {
        return this.doCompile(sourceCode).stream().collect(Collectors.toMap(ClassFile::getThisClassName, ClassFile::toByteArray, (a, b) -> b));
    }

    private List<ClassFile> doCompile(String sourceCode) throws CompileException, IOException {
        StringReader reader = new StringReader(sourceCode);
        Scanner scanner = new Scanner(null, (Reader)reader);
        Java.AbstractCompilationUnit compilationUnit = new Parser(scanner).parseAbstractCompilationUnit();
        ArrayList<ClassFile> classFiles = new ArrayList<ClassFile>();
        new UnitCompiler(compilationUnit, this.compilationClassLoader).compileUnit(this.debug, this.debug, this.debug, classFiles);
        return classFiles;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

