/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.apache.drill.exec.compile.AbstractClassCompiler;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.compile.DrillDiagnosticListener;
import org.apache.drill.exec.compile.DrillJavaFileManager;
import org.apache.drill.exec.compile.DrillJavaFileObject;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JDKClassCompiler
extends AbstractClassCompiler {
    private static final Logger logger = LoggerFactory.getLogger(JDKClassCompiler.class);
    private final Collection<String> compilerOptions;
    private final DiagnosticListener<JavaFileObject> listener;
    private final JavaCompiler compiler;
    private final ClassLoader classLoader;

    private JDKClassCompiler(JavaCompiler compiler, ClassLoader classLoader, boolean debug) {
        super(debug);
        this.compiler = compiler;
        this.listener = new DrillDiagnosticListener();
        this.classLoader = classLoader;
        this.compilerOptions = Lists.newArrayList(this.debug ? "-g:source,lines,vars" : "-g:none");
    }

    public static JDKClassCompiler newInstance(ClassLoader classLoader, boolean debug) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new RuntimeException("JDK Java compiler not available - probably you're running Drill with a JRE and not a JDK");
        }
        return new JDKClassCompiler(compiler, classLoader, debug);
    }

    @Override
    protected byte[][] getByteCode(ClassTransformer.ClassNames className, String sourceCode) throws CompileException, IOException, ClassNotFoundException {
        return this.doCompile(className, sourceCode).getByteCode();
    }

    @Override
    public Map<String, byte[]> compile(ClassTransformer.ClassNames className, String sourceCode) throws CompileException, IOException, ClassNotFoundException {
        return this.doCompile(className, sourceCode).getClassByteCodes();
    }

    private DrillJavaFileObject doCompile(ClassTransformer.ClassNames className, String sourceCode) throws CompileException, IOException, ClassNotFoundException {
        DrillJavaFileObject drillJavaFileObject;
        DrillJavaFileManager fileManager = new DrillJavaFileManager(this.compiler.getStandardFileManager(this.listener, null, Charsets.UTF_8), this.classLoader);
        try {
            DrillJavaFileObject compilationUnit = new DrillJavaFileObject(className.dot, sourceCode);
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, fileManager, this.listener, this.compilerOptions, null, Collections.singleton(compilationUnit));
            if (!task.call().booleanValue()) {
                throw new CompileException("Compilation failed", null);
            }
            if (!compilationUnit.isCompiled()) {
                throw new ClassNotFoundException(className + ": Class file not created by compilation.");
            }
            drillJavaFileObject = compilationUnit;
        }
        catch (Throwable compilationUnit) {
            try {
                try {
                    fileManager.close();
                }
                catch (Throwable throwable) {
                    compilationUnit.addSuppressed(throwable);
                }
                throw compilationUnit;
            }
            catch (RuntimeException rte) {
                Throwable cause = rte.getCause();
                if (cause != null) {
                    if ((cause = cause.getCause()) instanceof CompileException) {
                        throw (CompileException)cause;
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                }
                throw rte;
            }
        }
        fileManager.close();
        return drillJavaFileObject;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

