/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.exec.compile.FsmCursor;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class FsmDescriptor {
    private final Map<String, Character> tokenMap;
    private final Pattern fsmPattern;
    private final char lastTransition;

    public FsmDescriptor(Map<String, Character> tokenMap, String fsmRegex, String lastTransition) {
        Preconditions.checkNotNull(tokenMap);
        Preconditions.checkNotNull(fsmRegex);
        Preconditions.checkNotNull(lastTransition);
        Preconditions.checkArgument(tokenMap.containsKey(lastTransition));
        HashSet<Character> charSet = new HashSet<Character>();
        for (Map.Entry<String, Character> me : tokenMap.entrySet()) {
            Character character = me.getValue();
            if (charSet.contains(character)) {
                throw new IllegalArgumentException("Duplicate tokenMap char: '" + character + "'");
            }
            charSet.add(character);
        }
        this.tokenMap = Collections.unmodifiableMap(tokenMap);
        this.fsmPattern = Pattern.compile(fsmRegex);
        this.lastTransition = this.tokenMap.get(lastTransition).charValue();
    }

    public FsmCursor createCursor() {
        return new FsmCursor(this);
    }

    void validateTransitions(CharSequence transitions) {
        long length = transitions.length();
        if (length == 0L) {
            return;
        }
        Matcher matcher = this.fsmPattern.matcher(transitions);
        if (!matcher.find() || matcher.start() != 0 || (long)matcher.end() != length) {
            throw new IllegalStateException("Illegal state transition(s): " + transitions);
        }
    }

    char getChar(String token) {
        Preconditions.checkNotNull(token);
        Character character = this.tokenMap.get(token);
        Preconditions.checkNotNull(character);
        return character.charValue();
    }

    boolean isLastTransition(char transitionChar) {
        return transitionChar == this.lastTransition;
    }
}

