/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import org.apache.drill.exec.compile.FsmDescriptor;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class FsmCursor {
    private final FsmDescriptor fsmDescriptor;
    private final StringBuilder stringBuilder;

    FsmCursor(FsmDescriptor fsmDescriptor) {
        this.fsmDescriptor = fsmDescriptor;
        this.stringBuilder = new StringBuilder();
    }

    public void transition(String token) {
        Preconditions.checkNotNull(token);
        char c = this.fsmDescriptor.getChar(token);
        this.stringBuilder.append(c);
        if (this.fsmDescriptor.isLastTransition(c)) {
            this.fsmDescriptor.validateTransitions(this.stringBuilder);
        }
    }

    public void reset() {
        this.stringBuilder.setLength(0);
    }
}

