/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.io.IOException;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.apache.drill.exec.compile.DrillJavaFileObject;
import org.apache.drill.shaded.guava.com.google.common.base.Predicate;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private static final Logger logger = LoggerFactory.getLogger(DrillJavaFileManager.class);
    public static final Predicate<JavaFileObject.Kind> NO_SOURCES_KIND = input -> input != JavaFileObject.Kind.SOURCE;
    private final ClassLoader classLoader;

    protected DrillJavaFileManager(JavaFileManager fileManager, ClassLoader classLoader) {
        super(fileManager);
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        return super.list(location, packageName, Sets.filter(kinds, NO_SOURCES_KIND), recurse);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        logger.trace("Creating JavaFileForOutput@(location:{}, className:{}, kinds:{})", new Object[]{location, className, kind});
        if (sibling instanceof DrillJavaFileObject) {
            return ((DrillJavaFileObject)sibling).addOutputJavaFile(className);
        }
        throw new IOException("The source file passed to getJavaFileForOutput() is not a DrillJavaFileObject: " + sibling);
    }
}

