/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.compile.AbstractClassCompiler;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.compile.JDKClassCompiler;
import org.apache.drill.exec.compile.JaninoClassCompiler;
import org.apache.drill.exec.compile.QueryClassLoader;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.server.options.OptionMetaData;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.server.options.OptionValidator;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.TypeValidators;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassCompilerSelector {
    private static final Logger logger = LoggerFactory.getLogger(ClassCompilerSelector.class);
    public static final String JAVA_COMPILER_JANINO_MAXSIZE_CONFIG = "drill.exec.compile.janino_maxsize";
    public static final String JAVA_COMPILER_DEBUG_CONFIG = "drill.exec.compile.debug";
    public static final String JAVA_COMPILER_CONFIG = "drill.exec.compile.compiler";
    public static final String JAVA_COMPILER_OPTION = "exec.java_compiler";
    public static final String JAVA_COMPILER_JANINO_MAXSIZE_OPTION = "exec.java_compiler_janino_maxsize";
    public static final OptionValidator JAVA_COMPILER_JANINO_MAXSIZE = new TypeValidators.LongValidator("exec.java_compiler_janino_maxsize", new OptionValidator.OptionDescription("See the exec.java_compiler option comment. Accepts inputs of type LONG."));
    public static final String JAVA_COMPILER_DEBUG_OPTION = "exec.java_compiler_debug";
    public static final OptionValidator JAVA_COMPILER_DEBUG = new TypeValidators.BooleanValidator("exec.java_compiler_debug", new OptionValidator.OptionDescription("Toggles the output of debug-level compiler error messages in runtime generated code."));
    public static final TypeValidators.StringValidator JAVA_COMPILER_VALIDATOR = new TypeValidators.StringValidator("exec.java_compiler", new OptionValidator.OptionDescription("Switches between DEFAULT, JDK, and JANINO mode for the current session. Uses Janino by default for generated source code of less than exec.java_compiler_janino_maxsize; otherwise, switches to the JDK compiler.")){

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            super.validate(v, metaData, manager);
            try {
                CompilerPolicy.valueOf(v.string_val.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw UserException.validationError().message("Invalid value '%s' specified for option '%s'. Valid values are %s.", v.string_val, this.getOptionName(), Arrays.toString((Object[])CompilerPolicy.values())).build(QueryClassLoader.logger);
            }
        }
    };
    private final CompilerPolicy policy;
    private final long janinoThreshold;
    private final AbstractClassCompiler jdkClassCompiler;
    private final AbstractClassCompiler janinoClassCompiler;

    public ClassCompilerSelector(ClassLoader classLoader, DrillConfig config, OptionSet sessionOptions) {
        OptionValue value = sessionOptions.getOption(JAVA_COMPILER_OPTION);
        this.policy = CompilerPolicy.valueOf(value != null ? value.string_val.toUpperCase() : config.getString(JAVA_COMPILER_CONFIG).toUpperCase());
        value = sessionOptions.getOption(JAVA_COMPILER_JANINO_MAXSIZE_OPTION);
        this.janinoThreshold = value != null ? value.num_val.longValue() : config.getLong(JAVA_COMPILER_JANINO_MAXSIZE_CONFIG);
        value = sessionOptions.getOption(JAVA_COMPILER_DEBUG_OPTION);
        boolean debug = value != null ? value.bool_val.booleanValue() : config.getBoolean(JAVA_COMPILER_DEBUG_CONFIG);
        this.janinoClassCompiler = this.policy == CompilerPolicy.JANINO || this.policy == CompilerPolicy.DEFAULT ? new JaninoClassCompiler(classLoader, debug) : null;
        this.jdkClassCompiler = this.policy == CompilerPolicy.JDK || this.policy == CompilerPolicy.DEFAULT ? JDKClassCompiler.newInstance(classLoader, debug) : null;
        logger.info(String.format("Java compiler policy: %s, Debug option: %b", new Object[]{this.policy, debug}));
    }

    byte[][] getClassByteCode(ClassTransformer.ClassNames className, String sourceCode) throws CompileException, ClassNotFoundException, ClassTransformationException, IOException {
        byte[][] bc = this.getCompiler(sourceCode).getClassByteCode(className, sourceCode);
        return bc;
    }

    public Map<String, byte[]> compile(ClassTransformer.ClassNames className, String sourceCode) throws CompileException, ClassNotFoundException, ClassTransformationException, IOException {
        return this.getCompiler(sourceCode).compile(className, sourceCode);
    }

    private AbstractClassCompiler getCompiler(String sourceCode) {
        if (this.jdkClassCompiler != null && (this.policy == CompilerPolicy.JDK || this.policy == CompilerPolicy.DEFAULT && (long)sourceCode.length() > this.janinoThreshold)) {
            return this.jdkClassCompiler;
        }
        return this.janinoClassCompiler;
    }

    public static enum CompilerPolicy {
        DEFAULT,
        JDK,
        JANINO;

    }
}

