/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.compile.CachedClassLoader;
import org.apache.drill.exec.compile.ClassCompilerSelector;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.server.options.OptionSet;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ClassBuilder.class);
    public static final String CODE_DIR_OPTION = "drill.exec.compile.code_dir";
    private final DrillConfig config;
    private final OptionSet options;
    private final File codeDir;

    public ClassBuilder(DrillConfig config, OptionSet optionManager) {
        this.config = config;
        this.options = optionManager;
        this.codeDir = new File(config.getString(CODE_DIR_OPTION));
    }

    public Class<?> getImplementationClass(CodeGenerator<?> cg) throws ClassTransformationException {
        try {
            return this.compileClass(cg);
        }
        catch (IOException | ClassNotFoundException | CompileException e) {
            throw new ClassTransformationException(e);
        }
    }

    private Class<?> compileClass(CodeGenerator<?> cg) throws IOException, CompileException, ClassNotFoundException, ClassTransformationException {
        long t1 = System.nanoTime();
        String code = cg.getGeneratedCode();
        String className = cg.getMaterializedClassName();
        ClassTransformer.ClassNames name = new ClassTransformer.ClassNames(className);
        if (cg.isCodeToBeSaved()) {
            this.saveCode(code, name);
        }
        Class<?> compiledClass = ClassBuilder.getCompiledClass(code, className, this.config, this.options);
        logger.debug("Compiled {}: time = {} ms.", (Object)className, (Object)((System.nanoTime() - t1 + 500000L) / 1000000L));
        return compiledClass;
    }

    public static Class<?> getCompiledClass(String code, String className, DrillConfig config, OptionSet options) throws CompileException, ClassNotFoundException, ClassTransformationException, IOException {
        CachedClassLoader classLoader = new CachedClassLoader();
        ClassCompilerSelector compilerSelector = new ClassCompilerSelector(classLoader, config, options);
        ClassTransformer.ClassNames name = new ClassTransformer.ClassNames(className);
        Map<String, byte[]> results = compilerSelector.compile(name, code);
        classLoader.addClasses(results);
        try {
            return classLoader.findClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Code load failed", e);
        }
    }

    private void saveCode(String code, ClassTransformer.ClassNames name) {
        String pathName = name.slash + ".java";
        File codeFile = new File(this.codeDir, pathName);
        codeFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(codeFile);){
            writer.write(code);
        }
        catch (IOException e) {
            System.err.println("Could not save: " + codeFile.getAbsolutePath());
        }
    }
}

