/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.util.HashMap;
import org.apache.drill.exec.compile.CheckMethodVisitorFsm;
import org.apache.drill.exec.compile.FsmCursor;
import org.apache.drill.exec.compile.FsmDescriptor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class CheckClassVisitorFsm
extends ClassVisitor {
    private static final FsmDescriptor fsmDescriptor = CheckClassVisitorFsm.createFsmDescriptor();
    private final FsmCursor fsmCursor = fsmDescriptor.createCursor();

    private static FsmDescriptor createFsmDescriptor() {
        HashMap<String, Character> tokenMap = new HashMap<String, Character>();
        tokenMap.put("visit", Character.valueOf('v'));
        tokenMap.put("visitSource", Character.valueOf('S'));
        tokenMap.put("visitOuterClass", Character.valueOf('O'));
        tokenMap.put("visitAnnotation", Character.valueOf('A'));
        tokenMap.put("visitTypeAnnotation", Character.valueOf('T'));
        tokenMap.put("visitAttribute", Character.valueOf('R'));
        tokenMap.put("visitInnerClass", Character.valueOf('I'));
        tokenMap.put("visitField", Character.valueOf('F'));
        tokenMap.put("visitMethod", Character.valueOf('M'));
        tokenMap.put("visitEnd", Character.valueOf('E'));
        return new FsmDescriptor(tokenMap, "vS?+O?+(A|T|R)*+(I|F|M)*+E", "visitEnd");
    }

    public CheckClassVisitorFsm(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.fsmCursor.transition("visit");
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.fsmCursor.transition("visitAnnotation");
        AnnotationVisitor annotationVisitor = super.visitAnnotation(desc, visible);
        return annotationVisitor;
    }

    public void visitAttribute(Attribute attr) {
        this.fsmCursor.transition("visitAttribute");
        super.visitAttribute(attr);
    }

    public void visitEnd() {
        this.fsmCursor.transition("visitEnd");
        this.fsmCursor.reset();
        super.visitEnd();
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.fsmCursor.transition("visitField");
        FieldVisitor fieldVisitor = super.visitField(access, name, desc, signature, value);
        return fieldVisitor;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.fsmCursor.transition("visitInnerClass");
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.fsmCursor.transition("visitMethod");
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        return new CheckMethodVisitorFsm(this.api, methodVisitor);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.fsmCursor.transition("visitOuterClass");
        super.visitOuterClass(owner, name, desc);
    }

    public void visitSource(String source, String debug) {
        this.fsmCursor.transition("visitSource");
        super.visitSource(source, debug);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.fsmCursor.transition("visitTypeAnnotation");
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeRef, typePath, desc, visible);
        return annotationVisitor;
    }
}

