/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.cache;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.cache.LoopedAbstractDrillSerializable;
import org.apache.drill.exec.cache.VectorAccessibleSerializable;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.WritableBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedVectorContainer
extends LoopedAbstractDrillSerializable {
    private static final Logger logger = LoggerFactory.getLogger(CachedVectorContainer.class);
    private byte[] data;
    private final BufferAllocator allocator;
    private VectorContainer container;

    public CachedVectorContainer(WritableBatch batch, BufferAllocator allocator) {
        VectorAccessibleSerializable va = new VectorAccessibleSerializable(batch, allocator);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            va.writeToStream((OutputStream)baos);
        }
        catch (IOException e) {
            throw UserException.dataWriteError(e).addContext("Failed to write a cached batch to storage").build(logger);
        }
        this.allocator = allocator;
        this.data = baos.toByteArray();
        va.clear();
    }

    public CachedVectorContainer(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public CachedVectorContainer(byte[] data, BufferAllocator allocator) {
        this.data = data;
        this.allocator = allocator;
    }

    private void construct() {
        try {
            VectorAccessibleSerializable va = new VectorAccessibleSerializable(this.allocator);
            va.readFromStream(new ByteArrayInputStream(this.data));
            this.container = va.get();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void read(DataInput input) throws IOException {
        int len = input.readInt();
        this.data = new byte[len];
        input.readFully(this.data);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeInt(this.data.length);
        output.write(this.data);
    }

    public VectorAccessible get() {
        if (this.container == null) {
            this.construct();
        }
        return this.container;
    }

    public void clear() {
        if (this.container != null) {
            this.container.clear();
        }
        this.container = null;
    }

    public byte[] getData() {
        return this.data;
    }
}

