/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.alias;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.drill.exec.alias.Aliases;
import org.apache.drill.exec.alias.PersistentAliasRegistry;
import org.apache.drill.exec.store.sys.PersistentStore;

public class PersistentAliasesTable
implements Aliases {
    private final Map<String, String> aliases;
    private final String key;
    private final PersistentStore<PersistentAliasesTable> store;

    @JsonCreator
    public PersistentAliasesTable(@JsonProperty(value="aliases") Map<String, String> aliases, @JsonProperty(value="key") String key, @JacksonInject PersistentAliasRegistry.StoreProvider storeProvider) {
        this.aliases = aliases != null ? aliases : new HashMap();
        this.key = key;
        this.store = storeProvider.getStore();
    }

    @Override
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @Override
    public String get(String alias) {
        return this.aliases.get(alias);
    }

    @Override
    public boolean put(String alias, String value, boolean replace) {
        if (replace || !this.aliases.containsKey(alias)) {
            this.aliases.put(alias, value);
            this.store.put(this.key, this);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(String alias) {
        boolean isRemoved = this.aliases.remove(alias) != null;
        this.store.put(this.key, this);
        return isRemoved;
    }

    @Override
    @JsonIgnore
    public Iterator<Map.Entry<String, String>> getAllAliases() {
        return this.aliases.entrySet().iterator();
    }

    @JsonProperty(value="aliases")
    public Map<String, String> getAliases() {
        return this.aliases;
    }
}

