/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;

public class DrillFileUtils {
    public static final char SEPARATOR_CHAR = '/';
    public static final String SEPARATOR = "/";

    public static File getResourceAsFile(String fileName) throws IOException {
        URL u = DrillFileUtils.class.getResource(fileName);
        if (u == null) {
            throw new FileNotFoundException(String.format("Unable to find file on path %s", fileName));
        }
        return new File(u.getPath());
    }

    public static String getResourceAsString(String fileName) throws IOException {
        return org.apache.drill.shaded.guava.com.google.common.io.Files.asCharSource(DrillFileUtils.getResourceAsFile(fileName), Charsets.UTF_8).read();
    }

    public static File createTempDir() {
        try {
            return Files.createTempDirectory(System.currentTimeMillis() + "-", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temporary directory");
        }
    }
}

