/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainCredentialsProvider
implements CredentialsProvider {
    private static final Logger logger = LoggerFactory.getLogger(PlainCredentialsProvider.class);
    public static final CredentialsProvider EMPTY_CREDENTIALS_PROVIDER = new PlainCredentialsProvider(Collections.emptyMap());
    private final Map<String, String> credentials;
    private final Map<String, Map<String, String>> userCredentials;

    public PlainCredentialsProvider(Map<String, String> credentials) {
        this(credentials, new HashMap<String, Map<String, String>>());
    }

    @JsonCreator
    public PlainCredentialsProvider(@JsonProperty(value="credentials") Map<String, String> credentials, @JsonProperty(value="userCredentials") Map<String, Map<String, String>> userCredentials) {
        this.credentials = Optional.ofNullable(credentials).orElse(new HashMap());
        this.userCredentials = Optional.ofNullable(userCredentials).orElse(new HashMap());
    }

    @JsonIgnore
    public PlainCredentialsProvider(String username, Map<String, String> credentials) {
        this.credentials = new HashMap<String, String>();
        this.userCredentials = new HashMap<String, Map<String, String>>();
        this.userCredentials.put(username, credentials);
    }

    @Override
    @JsonIgnore(value=false)
    @JsonProperty(value="credentials")
    public Map<String, String> getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="userCredentials")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Map<String, String>> getUserCredentials() {
        return this.userCredentials;
    }

    @Override
    public Map<String, String> getUserCredentials(String queryUser) {
        assert (queryUser != null);
        logger.debug("Getting credentials for query user {}", (Object)queryUser);
        return this.userCredentials.getOrDefault(queryUser, new HashMap());
    }

    @Override
    public void setUserCredentials(String username, String password, String queryUser) {
        assert (queryUser != null);
        logger.debug("Setting credentials for query user {}", (Object)queryUser);
        Map creds = this.userCredentials.computeIfAbsent(queryUser, c -> new HashMap());
        creds.put("username", username);
        creds.put("password", password);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlainCredentialsProvider that = (PlainCredentialsProvider)o;
        return Objects.equals(this.credentials, that.credentials) && Objects.equals(this.userCredentials, that.userCredentials);
    }

    public int hashCode() {
        return Objects.hash(this.credentials, this.userCredentials);
    }

    public String toString() {
        return new PlanStringBuilder(this).field("credentials", this.credentials).field("userCredentials", this.userCredentials).toString();
    }
}

