/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.AbstractSingleBuilder;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.common.logical.data.SingleInputOperator;
import org.apache.drill.common.logical.data.visitors.LogicalVisitor;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterators;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

@JsonTypeName(value="window")
public class Window
extends SingleInputOperator {
    private final List<NamedExpression> withins;
    private final List<NamedExpression> aggregations;
    private final List<Order.Ordering> orderings;
    private final long start;
    private final long end;

    @JsonCreator
    public Window(@JsonProperty(value="withins") List<NamedExpression> withins, @JsonProperty(value="aggregations") List<NamedExpression> aggregations, @JsonProperty(value="orderings") List<Order.Ordering> orderings, @JsonProperty(value="start") Long start, @JsonProperty(value="end") Long end) {
        this.withins = withins;
        this.start = start == null ? Long.MIN_VALUE : start;
        this.end = end == null ? Long.MIN_VALUE : end;
        this.aggregations = aggregations;
        this.orderings = orderings;
    }

    public List<NamedExpression> getWithins() {
        return this.withins;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public List<NamedExpression> getAggregations() {
        return this.aggregations;
    }

    public List<Order.Ordering> getOrderings() {
        return this.orderings;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitWindow(this, value);
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return Iterators.singletonIterator(this.getInput());
    }

    public static class Builder
    extends AbstractSingleBuilder<Window, Builder> {
        private List<NamedExpression> aggregations = Lists.newArrayList();
        private List<NamedExpression> withins = Lists.newArrayList();
        private List<Order.Ordering> orderings = Lists.newArrayList();
        private long start = Long.MIN_VALUE;
        private long end = Long.MIN_VALUE;

        public Builder addAggregation(FieldReference ref, LogicalExpression expr) {
            this.aggregations.add(new NamedExpression(expr, ref));
            return this;
        }

        public Builder addWithin(FieldReference within, LogicalExpression expr) {
            this.withins.add(new NamedExpression(expr, within));
            return this;
        }

        @Override
        public Window internalBuild() {
            Preconditions.checkState(!this.withins.isEmpty(), "Withins in window must not be empty.");
            Preconditions.checkState(!this.aggregations.isEmpty(), "Aggregations in window must not be empty.");
            return new Window(this.withins, this.aggregations, this.orderings, this.start, this.end);
        }

        public Builder addOrdering(Order.Ordering ordering) {
            this.orderings.add(ordering);
            return this;
        }
    }
}

