/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import java.util.Collections;
import java.util.Iterator;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.LogicalExpressionBase;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CastExpression
extends LogicalExpressionBase
implements Iterable<LogicalExpression> {
    static final Logger logger = LoggerFactory.getLogger(CastExpression.class);
    private final LogicalExpression input;
    private final TypeProtos.MajorType type;

    public CastExpression(LogicalExpression input, TypeProtos.MajorType type, ExpressionPosition pos) {
        super(pos);
        this.input = input;
        this.type = Preconditions.checkNotNull(type, "Major type cannot be null");
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitCastExpression(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CastExpression)) {
            return false;
        }
        CastExpression other = (CastExpression)obj;
        return this.input.equals(other.input) && this.getMajorType().hasMinorType() == other.getMajorType().hasMinorType();
    }

    public int hashCode() {
        return (this.input.hashCode() << 8) + (0xFF & this.type.getMinorType().getNumber());
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        return Collections.singleton(this.input).iterator();
    }

    public LogicalExpression getInput() {
        return this.input;
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        return this.type;
    }

    public String toString() {
        return "CastExpression [input=" + this.input + ", type=" + this.type + "]";
    }
}

