/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.DynamicRootSchema;
import org.apache.calcite.jdbc.SimpleCalciteSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.alias.AliasRegistryProvider;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginRegistry;

public class DynamicSchema
extends SimpleCalciteSchema
implements AutoCloseable {
    public DynamicSchema(CalciteSchema parent, Schema schema, String name) {
        super(parent, schema, name);
    }

    protected CalciteSchema getImplicitSubSchema(String schemaName, boolean caseSensitive) {
        Schema s = this.schema.getSubSchema(schemaName);
        if (s != null) {
            return new DynamicSchema((CalciteSchema)this, s, schemaName);
        }
        return (CalciteSchema)this.getSubSchemaMap().get(schemaName);
    }

    public static SchemaPlus createRootSchema(StoragePluginRegistry storages, SchemaConfig schemaConfig, AliasRegistryProvider aliasRegistryProvider) {
        DynamicRootSchema rootSchema = new DynamicRootSchema(storages, schemaConfig, aliasRegistryProvider);
        return rootSchema.plus();
    }

    public CalciteSchema add(String name, Schema schema) {
        DynamicSchema calciteSchema = new DynamicSchema((CalciteSchema)this, schema, name);
        this.subSchemaMap.put(name, (Object)calciteSchema);
        return calciteSchema;
    }

    protected CalciteSchema.TableEntry getImplicitTable(String tableName, boolean caseSensitive) {
        return super.getImplicitTable(tableName, true);
    }

    @Override
    public void close() throws Exception {
        for (CalciteSchema cs : this.subSchemaMap.map().values()) {
            AutoCloseables.closeWithUserException((AutoCloseable)cs.plus().unwrap(AbstractSchema.class));
        }
    }
}

